%{
/*
 * Sumitup is like additup, a simple expression evaluator for floating
 * point numbers.
 */

#include <math.h>
#include <stdio.h>
#include "parse.tab.h"

%}

%%

[ \t\n]+		{ ; /* Pass them */ }
\+			{ return(PLUS_OP); }
-			{ return(MINUS_OP); }
\*			{ return(TIMES_OP); }
\/			{ return(DIVIDES_OP); }
\,			{ return(COMMA); }
\(			{ return(OPEN_PAREN); }
\)			{ return(CLOSE_PAREN); }
;			{ return(SEMICOLON); }
[0-9]+(\.[0-9]*)?	{ yylval.numerical = atof(yytext); return(CONSTANT); }
sin			{ yylval.function = sin; return(UNARY_FUNCTION); }
cos			{ yylval.function = cos; return(UNARY_FUNCTION); }
atan			{ yylval.function = atan; return(UNARY_FUNCTION); }
sqrt			{ yylval.function = sqrt; return(UNARY_FUNCTION); }
exp			{ yylval.function = exp; return(UNARY_FUNCTION); }
ln			{ yylval.function = log; return(UNARY_FUNCTION); }
pow			{ yylval.function = pow; return(BINARY_FUNCTION); }

%%

int yywrap()
{
  return 1;
}

