(*^
*)
  
GastropodShell[genus_, genusaperture_, phases_] := Module[ 
{l, gat, gae, i}, 
l = ReadGastropodShellParameters @ phases; 
gat = GastropodApertureTrajectoryParameters[genus, phases, l]; 
gae = GastropodApertureExpansionParameters[genusaperture, phases, l]; 
Map[ 
	PreDraw3D[WheelEllipse @@ #]&, 
	Flatten[ 
		Table[ 
			Thread @  
			{ 
				Line /@ Partition[ 
					GastropodApertureTrajectory @@ gat[[i]], 
						2, 1], 
				Drop[GastropodApertureExpansion @@ gae[[i]], -1] 
			}, 
			{i, 1, phases} 
		], 
		1 
	] 
] 
] 
 


(*


^*)