
Ray::usage = "Ray[l, x], where l is a line and x is a real number, is the line
of length x starting at the initial point of l and in the direction of l."

( Ray[Line @ {p_, q_}, _?NumberQ] := Line @ {p, q} 
	/; Chop @ Distance[p, q] == 0 )

Ray[Line @ {p_, q_}, x_?NumberQ] := Line[{p, p + x / Distance[p, q] (q - p)}]

Ray[x_?NumberQ, l_Line] := Ray[l, x]


