
Rotate::usage = "2D: Rotate[a, p][g] is the rotation of the figure g about the 
point p through the angle a. 
3D: Rotate[a, l][g] is the rotation of the figure g through the angle a about 
the line l."

( Rotate[a_?NumberQ, q:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	p:{_?NumberQ, _?NumberQ, _?NumberQ} := Block[
	{pp, qq},
	pp = Take[p, 2];
	qq = Take[q, 2];
	Append[
		PairProduct[pp - qq, {Cos[a], Sin[a]}] + qq,
	0.] ] )

( Rotate[a_?NumberQ, q:{_?NumberQ, _?NumberQ, _?NumberQ}] @ g_ := 
	MapAt[Rotate[a, q], g, 
		Position[g, {_?NumberQ, _?NumberQ, _?NumberQ}]] )

( Rotate[l_List, q:{_?NumberQ, _?NumberQ, _?NumberQ}] @ g_ := 
	Rotate[#, q] @ g & /@ l )

( Rotate[a_?NumberQ, Line @ {q_, r_}] @ 
	p:{_?NumberQ, _?NumberQ, _?NumberQ} := Block[
	{s = Prepend[Sin[a / 2] Unit[r - q], Cos[a / 2]],
	pp = Prepend[p - q, 0]}, 
	q + Chop @ Drop[QTimes[QTimes[QReciprocal[s], pp], s], 1] ] )

( Rotate[a_?NumberQ, l_Line] @ g_ := 
	MapAt[Rotate[a, l], g, 
		Position[g, {_?NumberQ, _?NumberQ, _?NumberQ}]] )

Rotate[a_?NumberQ, l_List] @ g_ := Rotate[a, #] @ g & /@ l

Rotate[a_List, l_] @ g_ := Rotate[#, l] @ g & /@ a

