
SphereLines::usage = "SphereLines[{u0, u1, du}, {v0, v1, dv}] gives a list of 
parts of the latitudes and longitudes on the sphere. The latitudes are between
angles v0 and v1 with a spacing of dv. The longitudes are between great 
circles at the angles u0 and u1 with a spacing of du."

( SphereLines[{u0_, u1_, du_}, {v0_, v1_, dv_}] := Module[
	{t = SphereTriples[{u0, u1, du}, {v0, v1, dv}]},
	{Line /@ t, Line /@ Thread[t]}
	]
)

