
Stretch::usage = "Stretch[l, x], where l is a line and x is a real number, is 
the line of length x with the same midpoint as l and in the direction of l."

( Stretch[Line @ {p_, q_}, _?NumberQ] := Line @ {p, q} 
	/; Chop @ Distance[p, q] == 0 )

( Stretch[Line @ {p_, q_}, x_?NumberQ] := Block[
	{s = Distance[p, q]},
	Block[
		{m = (p + q) / 2},
		Line[{x / s (p - m) + m, x / s (q - m) + m}] ] 
	/; Chop @ s != 0 ] )

( Stretch[Line @ l_List, x_?NumberQ] := Block[
	{s},
	s = Max[Distance[First @ First @ #, First @ Last @ #]& /@ 
		Flatten[Outer[List, head /@ l, head /@ l], 1]];
	Block[
	{m},
		m = (Plus @@ l) / Length @ l;
		Line[m + x / s (# - m) & /@ l] ]
	/; Chop @ s != 0 ] )

Stretch[x_?NumberQ, l_Line] := Stretch[l, x]



