
Functions["tangents.m"] = {Polar, Tangents}

Polar::usage = "Polar[p, u], where p is a point and u is a circle, is the 
line which is perpendicular to the line joining p to the center of u and 
passing through the inverse of p in u."

TangentPoints::usage = "TangentPoints[p, u], where p is a point and u is a 
circle, is the pair of points where the tangents from p to u meet the circle u."

Tangents::usage = "Tangents[p, u], where p is a point and u is a circle, is 
the pair of lines that are tangent to u from the point p."

( Polar[p:{_?NumberQ, _?NumberQ, _?NumberQ}, Circle[c_, r_]] := 
	Perpendicular[Line @ {p, c}, Invert[p, Circle[c, r]]] )

Polar[u_Circle, p:{_?NumberQ, _?NumberQ, _?NumberQ}] := Polar[p, u]

( TangentPoints[p:{_?NumberQ, _?NumberQ, _?NumberQ}, Circle[c_, r_]] := 
	{p, p}
	/; Distance[p, c] == r )

( TangentPoints[p:{_?NumberQ, _?NumberQ, _?NumberQ}, u:Circle[c_, r_]] := 
	Meet[u, Polar[p, u]] 
	/; Distance[p, c] > r )

( TangentPoints[u_Circle, p:{_?NumberQ, _?NumberQ, _?NumberQ}] := 
	TangentPoints[p, u] )

( Tangents[p:{_?NumberQ, _?NumberQ, _?NumberQ}, u:Circle[c_, r_]] := 
	{#, #} & @ Perpendicular[Line @ {p, c}, p]
	/; Distance[p, c] == r )

( Tangents[p:{_?NumberQ, _?NumberQ, _?NumberQ}, u:Circle[c_, r_]] := 
	Line[{p, #}] & /@ TangentPoints[p, u] 
	/; Distance[p, c] > r )

Tangents[u_Circle, p:{_?NumberQ, _?NumberQ, _?NumberQ}] := Tangents[p, u]

