(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Mar  5 08:36:41 PST 1992 by kalsow         *)
(*      modified on Mon Mar 11 23:31:37 1991 by muller         *)

UNSAFE INTERFACE RTException;

(* This interface provides access to the runtime machinery that
   raises exceptions.  The values of the types defined in this
   interface are generated by the compiler.  Changing any of the
   types below is dangerous. *)

IMPORT Csetjmp;

TYPE
  LOTS = [0..999999]; (* for "zero" terminated arrays *)

  ExceptionName = UNTRACED REF UNTRACED REF ARRAY LOTS OF CHAR;

  ExceptionArg = ADDRESS; (* actually, it's an untyped 4-byte field *)

  HandlerClass = { Except, ExceptElse, Finally, Raises, RaisesNone,
                   FinallyProc, Lock };


  RaisesNoneHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == RaisesNone *)
  END;

  RaisesHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == Raises *)
    handles : UNTRACED REF ARRAY LOTS OF ExceptionName;
  END;

  LockHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == Lock *)
    mutex   : MUTEX;
  END;

  FinallyProcHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == FinallyProc *)
    proc    : PROCEDURE (frame: ADDRESS) RAISES ANY;
    frame   : ADDRESS;
  END;

  Handler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == Except, ExceptElse, Finally *)
    handles : UNTRACED REF ARRAY LOTS OF ExceptionName;
    current : ExceptionName;
    arg     : ExceptionArg;
    jmp_buf : Csetjmp.jmp_buf;
  END;


PROCEDURE Raise (ex: ExceptionName;  arg: ExceptionArg) RAISES ANY;
(* raise the exception ex passing arg as the associated value *)

PROCEDURE RaiseForSure (e: ExceptionName;  arg: ExceptionArg) RAISES ANY;
(* after a TRY-FINALLY handler has been executed, restart the processing
   of the execption. It is known that there is a handler for this exception *)

PROCEDURE SanityCheck ();
(* performs some simple consistency checks on the running thread's
   exception stack.  If problems are found, a checked runtime error
   is generated. *)

END RTException.

