(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: MBuf.i3                                               *)
(* Last modified on Thu Aug 22 20:42:58 1991 by kalsow         *)

INTERFACE MBuf;

IMPORT Wr, FPrint;

TYPE T <: REFANY;

PROCEDURE New (): T;

PROCEDURE PutChar (t: T;  ch: CHAR);
PROCEDURE PutText (t: T;  txt: TEXT);
PROCEDURE PutInt  (t: T;  i: INTEGER);
PROCEDURE PutSub  (t: T;  READONLY x: ARRAY OF CHAR);

PROCEDURE ToText   (t: T): TEXT;
PROCEDURE ToFPrint (t: T): FPrint.T;
PROCEDURE Flush    (t: T;  wr: Wr.T);
PROCEDURE Append   (src, dest: T);

END MBuf.
