(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 10:16:48 PDT 1992 by muller                   *)
(*      modified on Tue Nov 26 18:20:52 PST 1991 by meehan                   *)

INTERFACE FilterRd;

(* A FilterRd.T is a "transparent filter". All operations performed on the
   parent are actually performed on the child, with one exception: closing
   the parent-reader will close the child-reader only if the parent was
   initialized with closeChild = TRUE. *)

IMPORT Rd;

TYPE
  Public = Rd.T OBJECT METHODS init (rd: Rd.T; closeChild := FALSE): T END;

  T <: Public;

END FilterRd.



