(*
   ExpandSimpleClient.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: ExpandSimpleClient.m3,v 1.2 1992/04/01 02:16:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * ExpandSimpleClient:
 *   Used with stub files generated from
 *       m3rpcgen -e [-f] expandsimple.x
 *)

IMPORT RPC, RPCSun, expandsimple, Thread;

IMPORT ParseParams, Scan, Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  b : RPCSun.BindingInfo;
  cl: expandsimple.Vers_1;

  HostName: TEXT := "localhost";

  l: INTEGER := 13;
  m: INTEGER := 42;
  n: INTEGER;

BEGIN
  TRY
    Wr.PutText(stdout, "Start of ExpandSimpleClient\n");

    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-h") THEN
      HostName := ParseParams.GetNext();
    END;
    ParseParams.EndParsing();

    b := RPCSun.CreateBindingInfo(
           RPCSun.LookupHost(HostName), expandsimple.Simple_prognum,
           expandsimple.Vers_1_versnum, 0, RPCSun.Protocol.UDP);
    cl := expandsimple.ImportVers_1(b);

    n := cl.Add(l, m);
    Wr.PutText(stdout, Fmt.F("Add(%s, %s) -> %s\n", Fmt.Int(l), Fmt.Int(m),
                             Fmt.Int(n)));

    Wr.PutText(stdout, "End of ExpandSimpleClient\n");
  EXCEPT
    Scan.BadFormat =>
      Wr.PutText(stderr, "Usage: ExpandSimpleClient -h host\n");
  | RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;

END Main.
