(*
   RecoverableSimpleClient.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: RecoverableSimpleClient.m3,v 1.2 1992/04/01 02:16:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * RecoverableSimpleClient:
 *   Used with stub files generated from
 *       m3rpcgen -r [-f] rsimple.x
 *)

IMPORT ExceptionArg, RPC, RPCSun, rsimple, Thread;

IMPORT ParseParams, Scan, Wr, Rd, Fmt;
FROM Stdio IMPORT stdin, stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  b : RPCSun.BindingInfo;
  cl: rsimple.Vers_1;

  HostName: TEXT := "localhost";

  m: INTEGER := 42;
  n: INTEGER;

PROCEDURE RecoveryProc (procNum : INTEGER;
                        numTries: CARDINAL;
                        arg     : ExceptionArg.T): RPCSun.Client
  RAISES {RPC.Failed} =
  VAR b: RPCSun.BindingInfo;
  BEGIN
    Wr.PutText(stdout, Fmt.F("RecoveryProc(%s, %s, ...)\n",
                             Fmt.Int(procNum), Fmt.Int(numTries)));
    Wr.Flush(stdout);
    IF numTries > 1 THEN
      RAISE RPC.Failed(arg);
    ELSE
      b := RPCSun.CreateBindingInfo(
             RPCSun.LookupHost(HostName), rsimple.Simple_prognum,
             rsimple.Vers_1_versnum, 0, RPCSun.Protocol.UDP);
      RETURN RPCSun.ImportService(b);
    END;
  END RecoveryProc;


BEGIN
  TRY
    Wr.PutText(stdout, "Start of RecoverableSimpleClient\n");

    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-h") THEN
      HostName := ParseParams.GetNext();
    END;
    ParseParams.EndParsing();

    b := RPCSun.CreateBindingInfo(
           RPCSun.LookupHost(HostName), rsimple.Simple_prognum,
           rsimple.Vers_1_versnum, 0, RPCSun.Protocol.UDP);
    cl := rsimple.ImportVers_1(b, RecoveryProc);

    n := cl.Incr(m);
    Wr.PutText(stdout, Fmt.F("Incr(%s) -> %s\n", Fmt.Int(m), Fmt.Int(n)));

    Wr.PutText(stdout, "Hit return when ready to make second call>");
    Wr.Flush(stdout);
    TRY 
      Wr.PutText(stdout, Fmt.F("%s\n", Rd.GetLine(stdin)));
    EXCEPT
      Rd.Failure, Rd.EndOfFile =>
    END;


    m := n;
    n := cl.Incr(m);
    Wr.PutText(stdout, Fmt.F("Incr(%s) -> %s\n", Fmt.Int(m), Fmt.Int(n)));

    Wr.PutText(stdout, "End of RecoverableSimpleClient\n");
  EXCEPT
    Scan.BadFormat =>
      Wr.PutText(stderr, "Usage: RecoverableSimpleClient -h host\n");
  | RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
