/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1988. */

#include "b.h"
#include "bfil.h"
#include "bmem.h"

Visible string messfile= (string) NULL;	/* error messages */
Visible string keysfile= (string) NULL;	/* key definitions */
Visible string helpfile= (string) NULL;	/* manual as help */

Visible string permfile= PERMFILE;	/* saves links file name vs. abc name */
Visible string suggfile= SUGGFILE;	/* saves user suggestions */
Visible string posfile= POSFILE;	/* saves focus positions */
Visible string typesfile= TYPESFILE;	/* saves typecode's */

Visible string buffile= BUFFILE;	/* saves copybuffer */

Visible string wsgroupfile= WSGROUPFILE; 
				/* saves links workspace name vs. abc name */
Visible string curwsfile= CURWSFILE;	/* saves last workspace */

Visible string tempfile= TEMPFILE;	/* temporary file */
Visible string temp1file= TEMP1FILE;	/* another temporary file */

Visible string editor;			/* another editor (via command line) */

Visible char *bwsdefault; /* full path name of the default group directory */
Visible char *startdir; /* full path name of the startup directory */

Visible char *makepath(path1, path2) char *path1, *path2; {
	if (path1 == NULL || *path1 == '\0')
		return savepath(path2);
	else if (path2 == NULL || *path2 == '\0')
		return savepath(path1);
	else {
		char *path, *ppath;
		int len;
	
		len= strlen(path1) + 1 + strlen(path2);
		path= (char *) getmem((unsigned) (len+1));
		strcpy(path, path1);
		ppath= path + strlen(path);
		if (ppath[-1] == DELIM && *path2 == DELIM)
			--ppath;
		else if (ppath[-1] != DELIM && *path2 != DELIM)
			*ppath++= DELIM;
		strcpy(ppath, path2);
		return path;
	}
}

Visible char *savepath(path) char *path; {
	if (path != NULL)
		return savestr(path);
	return (char *) NULL;
}

Visible Procedure freepath(path) char *path; {
	if (path != NULL)
		freestr(path);
}
