/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1989. */

#include "b.h"
#include "bmem.h"

extern bool in_vtrm;
extern bool raw_newline;

#ifdef KEYS
#define f_interactive(file) (isatty(fileno(file)))
#endif

#define LINELENGTH 200

Visible Procedure putstr(file, s) FILE *file; string s; {
	char buf[LINELENGTH];
	char *nl;
	char *line;
	int len;

	if (!f_interactive(file) || !raw_newline) {
		fputs(s, file);
		return;
	}
	for (; *s; s= ++nl) {
		if ((nl= strchr(s, '\n')) == NULL) {
			fputs(s, file);
			break;
		}
		len= nl-s;
		if (len > 0) {
			if (len >= LINELENGTH)
				line= (char *) getmem((unsigned) (len+1));
			else
				line= buf;
			strncpy(line, s, len);
			line[len]= '\0';
			fputs(line, file);
			if (len >= LINELENGTH)
				freestr(line);
		}
		fputs("\n\r", file);
	}
}

Visible Procedure putchr(file, c) FILE *file; char c; {
	if (c == '\n')
		putnewline(file);
	else
		putc(c, file);
}

Visible Procedure putnewline(file) FILE *file; {
	putc('\n', file);
	if (f_interactive(file) && raw_newline)
		putc('\r', file);
}

/***************************************************************************/

#define FMTLENGTH 600

Hidden char *fmtbuf;

Visible Procedure initfmt() {
	fmtbuf= (char *) getmem(FMTLENGTH);
}

#define FMTINTLEN 100 /* space allocated for int's in formats */

Hidden char *getfmtbuf(fmt, n) string fmt; int n; {
	static char *fmtstr= NULL;

	n+= strlen(fmt);
	if (fmtstr != NULL)
		freestr(fmtstr);
	if (n >= FMTLENGTH)
		return fmtstr= (char *) getmem((unsigned) n+1);
	return fmtbuf;
}

/***************************************************************************/

Visible Procedure putSstr(file, fmt, s) FILE *file; string fmt, s; {
	char *str= getfmtbuf(fmt, strlen(s));
	sprintf(str, fmt, s);
	putstr(file, str);
}

Visible Procedure putSDstr(file, fmt, s, d) FILE *file; string fmt, s; int d; {
	char *str= getfmtbuf(fmt, strlen(s)+FMTINTLEN);
	sprintf(str, fmt, s, d);	
	putstr(file, str);
}

Visible Procedure putDSstr(file, fmt, d, s) FILE *file; string fmt, s; int d; {
	char *str= getfmtbuf(fmt, FMTINTLEN+strlen(s));
	sprintf(str, fmt, d, s);	
	putstr(file, str);
}

Visible Procedure putDstr(file, fmt, d) FILE *file; string fmt; int d; {
	putDSstr(file, fmt, d, "");
}

Visible Procedure put3DSstr(file, fmt, d1, d2, d3, s)
		FILE *file; string fmt; int d1, d2, d3; string s; {
	char *str= getfmtbuf(fmt, 3*FMTINTLEN+strlen(s));
	sprintf(str, fmt, d1, d2, d3, s);
	putstr(file, str);
}

Visible Procedure put3Dstr(file, fmt, d1, d2, d3)
		FILE *file; string fmt; int d1, d2, d3; {
	put3DSstr(file, fmt, d1, d2, d3, "");
}

Visible Procedure put2Dstr(file, fmt, d1, d2)
		FILE *file; string fmt; int d1, d2; {
	put3DSstr(file, fmt, d1, d2, 0, "");
}

Visible Procedure put2Cstr(file, fmt, c1, c2)
		FILE *file; string fmt; char c1, c2; {
	char *str= getfmtbuf(fmt, 1+1);
	sprintf(str, fmt, c1, c2);
	putstr(file, str);
}

Visible Procedure putCstr(file, fmt, c) FILE *file; string fmt; char c; {
	put2Cstr(file, fmt, c, '\0');
}

/***************************************************************************/

Visible Procedure putmess(file, m) FILE *file; int m; {
	putstr(file, getmess(m));
	fflush(file);
}

Visible Procedure putSmess(file, m, s) FILE *file; int m; string s; {
	putSstr(file, getmess(m), s);
	fflush(file);
}

Visible Procedure putDSmess(file, m, d, s) FILE *file; int m; int d; string s; {
	putDSstr(file, getmess(m), d, s);
	fflush(file);
}

Visible Procedure put2Cmess(file, m, c1, c2) FILE *file; int m; char c1, c2; {
	put2Cstr(file, getmess(m), c1, c2);
	fflush(file);
}

