/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1986. */

/*
 * B editor -- Lexical elements (identifiers, keywords, numbers etc.)
 */

#include "b.h"
#include "bedi.h"
#include "bobj.h"
#include "node.h"
#include "tabl.h"

/*
 * Table defining lexical elements is generated by 'mktable' in e1tabl.c.
 *
 * ********** Indexed by (symbol-LEXICAL).
 */


/*
 * Test whether character `c' may start a lexical element with
 * symbolic name `lex'.
 */

Visible bool maystart(c, ilex) char c; int ilex; {
	string cp;

	ilex-= LEXICAL;
	Assert(0 <= ilex && ilex < NLEX);
	if (!isascii(c) || c != ' ' && !isprint(c))
		return No;
	cp= lextab[ilex].l_start;
	if (*cp == '^')
		return (strchr(cp+1, c) == NULL);
	return (strchr(cp, c) != NULL);
}


/*
 * Test whether character `c' may continue a lexical element with
 * symbolic name `ilex'.
 */

Visible bool maycontinue(c, ilex) char c; int ilex; {
	string cp;

	ilex-= LEXICAL;
	Assert(0 <= ilex && ilex < NLEX);
	if (!isascii(c) || c != ' ' && !isprint(c))
		return No;
	cp= lextab[ilex].l_continue;
	if (*cp == '^')
		return (strchr(cp+1, c) == NULL);
	return (strchr(cp, c) != NULL);
}
