/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1986. */

/* Generic routines for all values */

#include "b.h"
#include "bint.h"
#include "bmem.h"
#include "bobj.h"
#include "i1tlt.h"
#include "i3typ.h"

#define Len (len < 200 ? len : ((len-1)/8+1)*8)

Visible unsigned tltsyze(type, len, nptrs) 
	literal type;
	intlet len;
	int *nptrs;
{
	register unsigned syze= 0;
	*nptrs= 0;
	switch (type) {
	case Tex: syze= (len+1)*sizeof(char); *nptrs= 0; break;
	case ELT:
	case Lis:
	case Ran:
	case Tab: syze= Len*sizeof(value); *nptrs= len; break;
	}
	return syze;
}

Visible Procedure rel_subvalues(v) value v; {
	rrelease(v);
}

#define INCOMP	MESS(500, "incompatible types %s and %s")

Hidden Procedure incompatible(v, w) value v, w; {
	value m1, m2, m3, m;
	string s1, s2;
	
	m1= convert(m3= (value) valtype(v), No, No); release(m3);
	m2= convert(m3= (value) valtype(w), No, No); release(m3);
	s1= sstrval(m1);
	s2= sstrval(m2);
	sprintf(messbuf, getmess(INCOMP), s1, s2);
	m= mk_text(messbuf);
	interrV(-1, m);

	fstrval(s1); fstrval(s2);
	release(m1); release(m2);
	release(m);
}

Visible bool comp_ok;

#define Sgn(d) (d)

Visible relation compare(v, w) value v, w; {
	literal vt= Type(v), wt= Type(w);
	register intlet vlen, wlen, len, k;

	comp_ok= Yes;
	vlen= IsSmallInt(v) ? 0 : Length(v);
	wlen= IsSmallInt(w) ? 0 : Length(w);
	if (v == w) return 0;
	if (!(vt == wt && !(vt == Com && vlen != wlen) ||
			    vt == Ran && (wt == Lis || wt == ELT) ||
			    wt == Ran && (vt == Lis || vt == ELT) ||
			    vt == ELT && (wt == Lis || wt == Tab) ||
			    wt == ELT && (vt == Lis || vt == Tab))) {
		incompatible(v, w);
		comp_ok= No;
		return -1;
	}
	if (vt != Num && (vlen == 0 || wlen == 0))
		return Sgn(vlen-wlen);
	if (vt == Ran || wt == Ran)
		return range_comp(v, w);
	switch (vt) {
	case Num: return numcomp(v, w);
	case Tex: return strcmp(Str(v), Str(w));

	case Com:
	case Lis:
	case Tab:
	case ELT:
		{value *vp= Ats(v), *wp= Ats(w);
		 relation c;
			len= vlen < wlen ? vlen : wlen;
			for (k= 0; k < len; k++)
				if ((c= compare(*vp++, *wp++)) != 0)
					return c;
			return Sgn(vlen-wlen);
		}
	default:
		syserr(MESS(501, "comparison of unknown types"));
		/* NOTREACHED */
	}
}

Visible double hash(v) value v; {
	if (Is_number(v))
		return numhash(v);
	else {
		literal t= Type(v); intlet len= Length(v), k; 
		double d= t+.404*len;
		switch (t) {
		case Tex:
			{string vp= Str(v);
				for (k= 0; k < len; k++)
					d= .987*d+.277*(*vp++);
				return d;
			}
		case Com:
		case Lis:
		case Ran:
		case Tab:
		case ELT:
			{value *vp= Ats(v);
				if (len == 0) return .909;
				for (k= 0; k < len; k++)
					d= .874*d+.310*hash(*vp++);
				return d;
			}
		default:
			syserr(MESS(502, "hash called with unknown type"));
			/* NOTREACHED */
		}
	}
}

/* For reasons of efficiency, wri does not always call convert but writes
   directly on the standard output. Modifications in convert should
   be mirrored by changes in wri and vice versa. */

#ifdef RANGEPRINT
Hidden Procedure conc_vals(pt, l, u) value *pt; value l, u; {
	value x;
	if (compare(l, u) == 0)
		concato(pt, x= convert(l, No, No));
	else if (is_increment(u, l)) {
		concato(pt, x= convert(l, No, No)); release(x);
		concato(pt, x= mk_text("; ")); release(x);
		concato(pt, x= convert(u, No, No));
	}
	else {
		concato(pt, x= convert(l, No, No)); release(x);
		concato(pt, x= mk_text("..")); release(x);
		concato(pt, x= convert(u, No, No));
	}
	release(x);
}
#endif /* RANGEPRINT */

#define Last(k, len)	((k) == (len)-1)

Visible value convert(v, coll, outer) value v; bool coll, outer; {
	value t, quote, c, cv, sep, th, open, close, i, s;
	int k, len; char ch; relation r;
	switch (Type(v)) {
	case Num:
		return mk_text(convnum(v));
	case Tex:
		if (outer) return copy(v);
		quote= mk_text("\"");
		len= length(v);
		t= copy(quote);
		for (k=1; k<=len; k++) {
			c= thof(k, v);
			ch= charval(c);
			concato(&t, c);
			if (ch == '"' || ch == '`') concato(&t, c);
			release(c);
		}
		concato(&t, quote);
		release(quote);
		break;
	case Com:
		len= Nfields(v);
		outer&= coll;
		sep= mk_text(outer ? " " : ", ");
		t= mk_text(coll ? "" : "(");
		for (k= 0; k < len; k++) {
			concato(&t, cv= convert(*Field(v, k), No, outer));
			release(cv);
			if (!Last(k, len)) concato(&t, sep);
		}
		release(sep);
		if (!coll) {
			concato(&t, cv= mk_text(")"));
			release(cv);
		}
		break;
	case Ran:
	case Lis:
	case ELT:
		t= mk_text("{");
		sep= mk_text("; ");
#ifndef RANGEPRINT
		i= copy(one); s= size(v); 
		while ((r=numcomp(i, s)) <= 0) {
			th= item(v, i);
			concato(&t, cv= convert(th, No, No));
			if (r < 0) {
				concato(&t, sep);
			}
			release(cv); release(th);
			i= sum(th=i, one);
			release(th);
		}
		release(i); release(s);
#else /* RANGEPRINT */
		{
			value lwb, upb;
			bool first= Yes;
			i= copy(one); s= size(v);
			while (numcomp(i, s) <= 0) {
				th= item(v, i);
				if (first) {
					lwb= copy(th);
					upb= copy(th);
					first= No;
				}
				else if (is_increment(th, upb)) {
					release(upb);
					upb= copy(th);
				}
				else {
					conc_vals(&t, lwb, upb) ;
					concato(&t, sep);
					release(lwb); release(upb);
					lwb= copy(th); upb= copy(th);
				}
				release(th);
				i= sum(th=i, one);
				release(th);
			}
			if (!first) {
				conc_vals(&t, lwb, upb);
				release(lwb); release(upb);
			}
			release(i); release(s);
		}
#endif /* RANGEPRINT */
		concato(&t, cv= mk_text("}"));
		release(cv); release(sep);
		break;
	case Tab:
		len= length(v);
		open= mk_text("[");
		close= mk_text("]: ");
		sep= mk_text("; ");
		t= mk_text("{");
		for (k= 0; k < len; k++) {
			concato(&t, open);
			concato(&t, cv= convert(*key(v, k), Yes, No));
			release(cv);
			concato(&t, close);
			concato(&t, cv= convert(*assoc(v, k), No, No));
			release(cv);
			if (!Last(k, len)) concato(&t, sep);
		}
		concato(&t, cv= mk_text("}")); release(cv);
		release(open); release(close); release(sep);
		break;
	default:
		syserr(MESS(503, "unknown type in convert"));
	}
	return t;
}

#define Left 'L'
#define Right 'R'
#define Centre 'C'

#define ADJLEFT_NUM	MESS(504, "in t<<n, n is not a number")
#define ADJRIGHT_NUM	MESS(505, "in t><n, n is not a number")
#define CENTRE_NUM	MESS(506, "in t>>n, n is not a number")

Hidden value adj(x, y, side) value x, y; literal side; {
	value r, v= convert(x, Yes, Yes); int i;
	intlet lv, la, k, ls, rs;
	string rp, vp;

	if (!Is_number(y)) {
		switch (side) {
		case Left:	interr(ADJLEFT_NUM); break;
		case Centre:	interr(ADJRIGHT_NUM); break;
		case Right:	interr(CENTRE_NUM); break;
		}
		return v;
	}
	i= intval(y);
	lv= Length(v);
	la= propintlet(i) - lv;
	if (la <= 0) return v;
	r= grab(Tex, lv+la); rp= Str(r); vp= Str(v);

	if (side == Left) { ls= 0; rs= la; }
	else if (side == Centre) { ls= la/2; rs= (la+1)/2; }
	else { ls= la; rs= 0; }

	for (k= 0; k < ls; k++) *rp++= ' ';
	for (k= 0; k < lv; k++) *rp++= *vp++;
	for (k= 0; k < rs; k++) *rp++= ' ';
	*rp= 0;
	release(v);
	return r;
}

Visible value adjleft(x, y) value x, y; {
	return adj(x, y, Left);
}

Visible value centre(x, y) value x, y; {
	return adj(x, y, Centre);
}

Visible value adjright(x, y) value x, y; {
	return adj(x, y, Right);
}


