/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1986. */

/* B texts */

#include "b.h"
#include "bmem.h"
#include "bobj.h"
#include "i1tlt.h"

#define CURTAIL_TEX	MESS(200, "in t|n, t is not a text")
#define CURTAIL_NUM	MESS(201, "in t|n, n is not a number")
#define CURTAIL_INT	MESS(202, "in t|n, n is not an integer")
#define CURTAIL_BND	MESS(203, "in t|n, n is < 0")

#define BEHEAD_TEX	MESS(204, "in t@n, t is not a text")
#define BEHEAD_NUM	MESS(205, "in t@n, n is not a number")
#define BEHEAD_INT	MESS(206, "in t@n, n is not an integer")
#define BEHEAD_BND	MESS(207, "in t@n, n is > #t + 1")

#define CONCAT_TEX	MESS(208, "in t^u, t or u is not a text")
#define CONCAT_LONG	MESS(209, "in t^u, the result is too long")

#define REPEAT_TEX	MESS(210, "in t^^n, t is not a text")
#define REPEAT_NUM	MESS(211, "in t^^n, n is not a number")
#define REPEAT_INT	MESS(212, "in t^^n, n is not an integer")
#define REPEAT_NEG	MESS(213, "in t^^n, n is negative")
#define REPEAT_LONG	MESS(214, "in t^^n, the result is too long")

Visible value mk_text(m) string m; {
	value v; intlet len= strlen(m);
	v= grab(Tex, len);
	strcpy(Str(v), m);
	return v;
}

Visible bool character(v) value v; {
	if (Is_text(v) && Length(v) == 1) return Yes;
	else return No;
}

Visible char charval(v) value v; {
	if (!Is_text(v) || Length(v) != 1) 
		interr(MESS(215, "value not a character"));
	return *Str(v);
}

Visible char ncharval(n, v) int n; value v; {
	return *(Str(v)+n-1);
}

Visible string strval(v) value v; {
	return Str(v);
}

Visible string sstrval(v) value v; {
	return savestr((string) Str(v));
}

Visible Procedure fstrval(s) string s; {
	freestr(s);
}

Visible value concat(s, t) value s, t; {
	if (Type(s) != Tex || Type(t) != Tex)
		interr(CONCAT_TEX);
	else {
		value c= grab(Tex, Length(s)+Length(t));
		strcpy(Str(c), Str(s)); strcpy(Str(c)+Length(s), Str(t));
		return c;
	}
	return grab(Tex, 0);
}

Visible Procedure concato(s, t) value *s, t; {
	value v= *s;
	*s= concat(*s, t);
	release(v);
}

Visible value icurtail(v, k) value v; int k; {
	if (k >= Length(v))
		return copy(v);
	else {
		value w= grab(Tex, k);
		strncpy(Str(w), Str(v), k);
		*(Str(w) + k)= '\0';
		return w;
	}
}

Visible value curtail(v, n) value v, n; {
	if (!Is_text(v))
		interr(CURTAIL_TEX);
	else if (!Is_number(n))
		interr(CURTAIL_NUM);
	else if (!integral(n))
		interr(CURTAIL_INT);
	else {
		intlet k= intval(n);
		if (k < 0) interr(CURTAIL_BND);
		else return icurtail(v, k);
	}
	return grab(Tex, 0);
}

Visible value ibehead(v, k) value v; int k; {
	if (k <= 1)
		return copy(v);
	else {
		value w= grab(Tex, Length(v) - (k - 1));
		strcpy(Str(w), Str(v) + k - 1);
		return w;
	}
}

Visible value behead(v, n) value v, n; {
	if (!Is_text(v))
		interr(BEHEAD_TEX);
	else if (!Is_number(n))
		interr(BEHEAD_NUM);
	else if (!integral(n))
		interr(BEHEAD_INT);
	else {
		intlet b= intval(n);
		if (b > Length(v) + 1) interr(BEHEAD_BND);
		else return ibehead(v, b);
	}
	return grab(Tex, 0);
}

Visible value repeat(x, y) value x, y; {
	intlet i;
	if (Type(x) != Tex) {
		interr(REPEAT_TEX);
		return grab(Tex, 0);
	}
	if (!Is_number(y)) {
		interr(REPEAT_NUM);
		return grab(Tex, 0);
	}
	i= propintlet(intval(y));
	if (i < 0)
		interr(REPEAT_NEG);
	else {
		value r; string xp, rp; intlet p, q, xl= Length(x);
		intlet ixl= propintlet(i*xl);
#ifdef IBMPC
		bool enough_space();
		if (!enough_space(Tex, ixl)) {
			interr(REPEAT_LONG);
			return grab(Tex, 0);
		}
#endif
		r= grab(Tex, ixl);
		rp= Str(r);
		for (p= 0; p < i; p++) {
			xp= Str(x);
			for (q= 0; q < xl; q++) *rp++= *xp++;
		}
		*rp= '\0';
		return r;
	}
	return grab(Tex, 0);
}

Visible Procedure wrtext(putch, v, quote) int (*putch)(); value v; char quote; {
		char c; int k, len= Length(v);
		if (quote) (*putch)(quote);
		for (k=0; k<len && still_ok; k++) {
			c= ncharval(k+1, v);
			(*putch)(c);
			if (quote && (c == quote || c == '`'))
				(*putch)(c);
		}
		if (quote) (*putch)(quote);
}
