/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1988. */

#include "b.h"
#include "bmem.h"
#include "dest.h"
#include "bfil.h"

extern char *getenv();
extern char *getwd();

Visible char *curdir() {
	static char buffer[SIZE_PATH];
	return getwd(buffer);
}

Hidden string searchfile(base, abclib) string base; string abclib; {
	char *file;
	
	/* search first in startup directory */
	file= makepath(startdir, base);
	if (F_readable(file))
		return (string) file;
	freepath(file);

	/* then in bwsdefault */
	if (bwsdefault != NULL) {
		file= makepath(bwsdefault, base);
		if (F_readable(file))
			return (string) file;
		freepath(file);
	}
		
	/* next first in abclib */
	file= makepath(abclib, base);
	if (F_readable(file))
		return (string) file;
	freepath(file);

	/* else fail */
	return (string) NULL;
}

Visible Procedure initfile() {
	char *homedir= getenv("HOME");
	char *termname;
	string termfile;
	
	startdir= savepath(curdir());
	bwsdefault= homedir ? makepath(homedir, BWSNAME) : (char *) NULL;
	messfile= searchfile(MESSFILE, ABCLIB);
	helpfile= searchfile(HELPFILE, ABCLIB);
	buffile= homedir ? makepath(homedir, BUFFILE) : savepath(BUFFILE);
	
	if (editor != (string) NULL)
		return;	/* we don't need the keydefinitions file */

	if ((termname= getenv("TERM")) != NULL) {
		termfile= (string) getmem((unsigned) strlen(KEYSPREFIX)+strlen(termname));
		strcpy(termfile, KEYSPREFIX);
		strcat(termfile, termname);
		keysfile= searchfile(termfile, ABCLIB);
		freemem(termfile);
	}
	if (keysfile == (string)NULL) {
		keysfile= searchfile(KEYSFILE, ABCLIB);
	}
}

Visible Procedure endfile() {
	freepath(startdir);
	freepath(bwsdefault);
	freepath(messfile);
	freepath(keysfile);
	freepath(helpfile);
	freepath(buffile);
}
