/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1989. */

#include "b.h"
#include "bmem.h"
#include "bfil.h"
#include "getopt.h"
#include "i3bws.h"

Hidden Procedure abc_usage() {
	int m;
	
	/* dirty use of message numbers below: */
	for (m= 6900; m <= 6915; m++)
		putmess(errfile, m);
	
	exit(-1);
}

#define USE00 MESS(6900, "\nUsage:  abc [-W ws.group] [-w ws.name]\n")
#define USE01 MESS(6901, "            [ -e | -i tab | -o tab | -l | -r | -R | file ...]\n")
#define USE02 MESS(6902, "\nWorkspace Options:\n")
#define USE03 MESS(6903, "     -W dir        use group of workspaces in 'dir' (default $HOME/abc)\n")
#define USE04 MESS(6904, "     -w name       start in workspace 'name' (default: last workspace)\n")
#define USE05 MESS(6905, "     -w path       use 'path' as current workspace (no -W option allowed)\n")
#define USE06 MESS(6906, "\nOther Options:\n")
#define USE07 MESS(6907, "     -e            Use ${EDITOR} as editor to edit definitions\n")
#define USE08 MESS(6908, "     file ...      Read commands from file(s)\n")
#define USE09 MESS(6909, "\nSpecial tasks:\n")
#define USE10 MESS(6910, "     -i tab        Fill table 'tab' with text lines from standard input\n")
#define USE11 MESS(6911, "     -o tab        Write text lines from table 'tab' to standard output\n")
#define USE12 MESS(6912, "     -l            List the how-to's in a workspace on standard output\n")
#define USE13 MESS(6913, "     -r            Recover a workspace when its index is lost\n")
#define USE14 MESS(6914, "     -R            Recover the index of a group of workspaces\n")
#define USE15 MESS(6915, "\nUse 'abckeys' to change key bindings\n")


#define INCOMP_OPTIONS	MESS(6916, "*** incompatible workspace options\n")
#define NO_EDITOR MESS(6917, "*** you have not set your environment variable EDITOR\n")

Visible char *bws_arg= (char *) NULL;
			/* -W bws_arg: group name workspaces */
Visible char *wsp_arg= (char *) NULL;
			/* -w wsp_arg: start workspace */

Visible bool eflag= No;
			/* -e: use ${EDITOR} instaed of ABC-editor */
Visible bool is_gr_reccall= No;
			/* -R: recover workspace group index */

Visible bool slowterminal= No;
			/* -S: do not tell "cannot insert" on slow terminal */
Visible bool hushbaby= No;
			/* -H: no audible bell if you're babysitting */

Visible bool use_bed= Yes;
			/* the abc editor will be used, so initbed() etc. */

#ifndef NDEBUG

/* use -DDUMPKEYS, -DMEMTRACE, -DEDITRACE, -DTYPETRACE -D VTRMTRACE during
 * compilation to enable these flags.
 */

Visible bool dflag= No;
		/* -d: debugging output wanted */

#ifdef DUMPKEYS
Visible bool kflag= No;
		/* -k: dump keybindings at various stages */
#endif

#ifdef MEMTRACE
Hidden string memfile= NULL;
Visible FILE *memfp= NULL;
		/* -M memfile: trace memory allocations to memfile */
#endif

#ifdef EDITRACE
Visible string dumpfile= NULL;
Visible FILE *dumpfp= NULL;
		/* -E dumpfile: dump editor environ-info to dumpfile */
#endif

#ifdef TYPETRACE
Visible string stc_file= NULL;
Visible FILE *stc_fp= NULL;
		/* -T stc_file: trace typechecker on stc_file */
#endif

#ifdef VTRMTRACE
Visible string vtrmfile= NULL;
Visible FILE *vtrmfp= NULL;
		/* -V vtrmfile: trace typechecker on vtrmfile */
#endif

#endif /*NDEBUG */

#define NONE '\0'

main(argc, argv) int argc; char **argv; {
	int c;
	char *sbuf;
	char io_option= NONE;
	char *io_table= (char *) NULL;
	bool usage_error= No;

#ifdef NDEBUG
	while ((c= getopt(argc, argv, "W:w:ei:o:lrRSH")) != EOF) {
#else
	while ((c= getopt(argc, argv, "W:w:ei:o:lrRSHdkM:E:T:V:")) != EOF) {
#endif
		switch (c) {
		case 'W':
			if (bws_arg) usage_error= Yes;
			else bws_arg= optarg;
			break;
		case 'w':
			if (wsp_arg) usage_error= Yes;
			else wsp_arg= optarg;
			break;
		case 'e':
			if (eflag || io_option) usage_error= Yes;
			else eflag= Yes;
			break;
		case 'i':
		case 'o':
			io_table= optarg;
		case 'l':
		case 'r':
		case 'R':
			if (eflag || io_option) usage_error= Yes;
			else io_option= c;
			if (c == 'R')
				is_gr_reccall= Yes;
			break;

		case 'S':
			slowterminal= Yes;
			break;
		case 'H':
			hushbaby= Yes;
			break;

#ifndef NDEBUG
		case 'd':
			dflag= Yes;
			break;
#ifdef DUMPKEYS
		case 'k':
			kflag= Yes;
			break;
#endif
#ifdef MEMTRACE
		case 'M':
			memfile= optarg;
			break;
#endif
#ifdef EDITRACE
		case 'E':
			dumpfile= optarg;
			break;
#endif
#ifdef TYPETRACE
		case 'T':
			stc_file= optarg;
			break;
#endif
#ifdef VTRMTRACE
		case 'V':
			vtrmfile= optarg;
			break;
#endif
#endif /* !NDEBUG */

		default:
			usage_error= Yes;
			break;
		}
	}

	argc -= optind;
	argv += optind;
	
	if (argc > 0 && (eflag || io_option))
		usage_error= Yes;
	
#ifndef NDEBUG
#ifdef MEMTRACE
	if (memfile != NULL)
		memfp= fopen(memfile, "w");
#endif
#ifdef EDITRACE
	if (dumpfile != NULL)
		dumpfp= fopen(dumpfile, "w");
#endif
#ifdef TYPETRACE
	if (stc_file != NULL)
		stc_fp= fopen(stc_file, "w");
#endif
#ifdef VTRMTRACE
	if (vtrmfile != NULL)
		vtrmfp= fopen(vtrmfile, "w");
#endif
#endif

	/* Setbuf must be called before any output is produced! */
	sbuf= (char*) getmem((unsigned)BUFSIZ);
	setbuf(stdout, sbuf);
	
	set_vars();	/* set messfile and errfile before using
			 * usage messages ! */
	
	if (is_path(wsp_arg) && bws_arg) {
		putmess(errfile, INCOMP_OPTIONS);
		usage_error= Yes;
	}
	
	if (eflag) {
		editor= (string) getenv("EDITOR");
		if (editor == (string)NULL || *editor == NONE) {
			putmess(errfile, NO_EDITOR);
			usage_error= Yes;
		}
	}
	
	if (usage_error)
		abc_usage();	/* exits */
	
	initcall(argc, argv);
	
	use_bed= rd_interactive && (io_option == NONE || io_option == 'i');
	
	init((bool) (io_option == NONE));
	if (io_option)
		abcio(io_option, io_table);
	else
		run_abc(argc, argv);

	freemem((ptr) sbuf);

	bye(0);
}
