/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1988. */

#include "b.h"
#include "feat.h"

#ifndef NDEBUG

/* Assertion error */

Visible Procedure asserr(file, line) string file; int line; {

	putSDstr(errfile, "Assertion failed: file %s, line %d\n", file, line);
	trmend(); /* quick hack to reset ttymodes */
	bye(-1);
}

#endif /* !NDEBUG */

#ifndef HAS_GETWD

/* getwd - get working directory */

Visible char *getwd(buf) char *buf; {
	FILE *fp;

	*buf = 0;
	if ((fp=popen("pwd", "r")) == 0 ) {
		strcpy(buf, "cannot execute pwd");
		return(0);
	}
	if (fgets(buf, 1024, fp) )
		buf[strlen(buf)-1] = 0;
	pclose(fp);
	if (*buf == '/')
		return buf;
	else
		return (char*) NULL;
}

#endif /* !HAS_GETWD */

#ifndef HAS_RENAME

/* rename - rename a file */

Visible Procedure rename(from, to) char *from, *to; {
	int i;

	if( (i=link(from, to)) < 0 ) return(i);
	if( (i=unlink(from)) < 0 ) {
		unlink(to);
		return(i);
	}
	return(0);
}

#endif /* !HAS_RENAME */
