/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1989. */

#include "b.h"
#include "bobj.h"
#include "i1num.h"

#include <time.h>

#ifdef HAS_FTIME	/* Berkeley */

#include <sys/timeb.h>

Visible value nowisthetime() {
	struct tm *lt;
	struct timeb tt;
	value now;
	value millisecs;
	value thousand;
	
	ftime(&tt);
	lt= localtime((long*) &tt.time);
	
	now= mk_compound(6);

	*Field(now, 0)= mk_integer(lt->tm_year + 1900);
	*Field(now, 1)= mk_integer(lt->tm_mon + 1);
	*Field(now, 2)= mk_integer(lt->tm_mday);
	*Field(now, 3)= mk_integer(lt->tm_hour);
	*Field(now, 4)= mk_integer(lt->tm_min);
	millisecs= mk_integer((int) (lt->tm_sec * 1000 + tt.millitm));
	thousand= mk_integer(1000);
	*Field(now, 5)= mk_exact(millisecs, thousand, 3);
	release(millisecs); release(thousand);
	return now;
}

#else

Visible value nowisthetime() {
	long ttt;
	struct tm *lt;
	value now;
	
	ttt= time((long*)0);
	lt= localtime(&ttt);
	
	now= mk_compound(6);

	*Field(now, 0)= mk_integer(lt->tm_year + 1900);
	*Field(now, 1)= mk_integer(lt->tm_mon + 1);
	*Field(now, 2)= mk_integer(lt->tm_mday);
	*Field(now, 3)= mk_integer(lt->tm_hour);
	*Field(now, 4)= mk_integer(lt->tm_min);
	*Field(now, 5)= mk_integer(lt->tm_sec);
	
	return now;
}

#endif
