//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed stop() from friend to member function.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

#if defined(DOS)
extern "C" {
#include <stdlib.h>				// For exit()
}
#else
#include <stdlib.h>				// For exit()
#endif

// void Excption::stop() --  Searches for an Exception Handler to handle the
//                           specified Exception and if either no Excp Handlers
//                           are found or if the Excp Handler function which is
//                           invoked reports the Exception message on stderr
//                           and terminate program with exit().
//                           This function will never return to caller.
//
// Input:  None
// Output: None

void Exception::stop() {
  this->raise();
  cerr << this;
  if (this->is_handled())
    cerr << "\nWarning: Exception Handler returned while in STOP.\n";
  exit(1);
}
