//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 06/06/89 -- Initial implementation
// Updated: LGO 09/19/89 -- Split into one file per method
// Updated: MBN 10/12/89 -- Changed "current_position" to "curpos" 

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// Hash_Table -- Simple constructor with one argument that creates a hash
//               table object with the minimal prime number of buckets that
//               holds some user-supplied number of items and uses the default
//               hash function.
// Input:        Minimal number of items table must hold
// Output:       None

Hash_Table::Hash_Table (long n) {
  this->growth_ratio = 0.0;			// Grow to next prime number
  this->entry_count = 0;			// No entries in table
  this->current_bucket = 0;			// Index to number of buckets
  this->curpos = INVALID;			// Invalidate current position
  while (hash_primes[this->current_bucket]*BUCKET_SIZE < n) // Find prime big
    this->current_bucket++;		        // ... enough for number items
  long prime = hash_primes[this->current_bucket]; // Get prime number 
  this->items_in_buckets = new unsigned char[prime]; // Counts items in buckets
  for (long i = 0; i < prime; i++)		 // For each bucket count
    this->items_in_buckets[i] = 0;		 // Initialize to zero
}
