//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Updated: MBN 01/03/90 -- Updated calling sequence for strfind()

#include <cool/String.h>
#include <cool/char.h>
#include <cool/Package.h>

// Find the next symbol whose pname contains name, starting after current
// position.  If found, return TRUE and set new current position.
Boolean apropos(Package& pkg, const char* name) {
  while (pkg.next())
    if (strfind(pkg.value()->name(), name) != NULL)
      return TRUE;
  return FALSE;
}
