//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/02/90 -- Make c_trim, c_left_trim, c_right_trim modify
//                          in-place, instead of copy.
// Updated: LGO 01/05/90 -- Split into seperate files
//

#include <cool/char.h>		// Include char* specification header file

#if defined(DOS)
extern "C" {
#include <ctype.h>		// Include character processing macros
}
#else
#include <ctype.h>		// Include character processing macros
#endif

// c_left_trim -- Removes any occurrence of the character(s) in "rem" from
//                "str" that appear as a prefix to the string. The first
//                non-matching character encountered terminates the remove
//                operation and the rest of the string is copied intact.
// Input:         Source string and token string
// Output:        Modified string "str" (string modified in place)

char* c_left_trim (char* str, const char* rem) { // Trim prefix from string
  char* result = str;
  char* s;
  register char c;
  for (s=str; (c=*s) != END_OF_STRING; s++) {
    register const char* r = rem;
    register char t;
    while ((t=*r++) != END_OF_STRING && t != c); // Scan for match
    if (t == END_OF_STRING)			 // If no match found
      break;
  }
  if (s != result)				  // when characters trimed
    while ((*result++ = *s++) != END_OF_STRING); // shift string down
  return str;					  // Return pointer to string
}
