/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
/*
//-----------------------------------------------------------------------------
//
// $Source: /usr/proj/grl/motifplb/design_review_1_efforts/lib_1/XMObject.hh,v $
// $Revision: 1.9 $
// $State: Exp $
// $Author: kseethar $
// $Date: 89/12/07 15:27:28 $
// $Locker:  $
//
// $Log:	XMObject.hh,v $
Revision 1.9  89/12/07  15:27:28  kseethar
added XMString, KS

Revision 1.8  89/12/05  09:44:54  grlcr
Added Xt calls

Revision 1.7  89/11/29  13:50:36  grlcr
*** empty log message ***

Revision 1.6  89/11/29  11:14:29  bmontagu
Added most Xt functions

Revision 1.5  89/11/15  12:58:35  grlcr
*** empty log message ***

Revision 1.4  89/11/08  10:38:02  grlcr
*** empty log message ***

Revision 1.3  89/11/03  18:20:14  grlcr
major reworking

Revision 1.2  89/11/03  09:22:14  grlcr
*** empty log message ***

Revision 1.1  89/11/02  12:29:50  motifplb
Initial revision

// ***** Created Oct 11, 1989 by Krishnan *****
// ***** grlcr: reworked, Nov 3 *****
// ***** bruce: added hash table stuff *****
//-----------------------------------------------------------------------------
*/


/* ------------------------------------------------------------------------
These documented routines are not present in the XT source code and thus
are not supported in this binding
XtCallAcceptFocus
XtGetSelectionValueIncremental
XtGetSelectionValuesIncremental
XtOwnSelectionIncremental
 ------------------------------------------------------------------------*/


#ifndef XMObject_hh
#define XMObject_hh

#ifndef NeedFunctionPrototypes
#define NeedFunctionPrototypes 1
#endif /* NeedFunctionPrototypes */

#ifndef XTFUNCPROTO
#define XTFUNCPROTO 1
#endif /* XTFUNCPROTO */



#include "XMMACROS.h"
#include "XMString.hh"                         // XMString class
#include "XMFontList.hh"                       // XMFontList class

#include <stdlib.h>
#include <X11/X.h>    
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>
#include <Xm/SelectioB.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>


class XMObject;

typedef XMObject* XMObjectList;

struct class_bind {
     struct class_bind*  cb_flink;
     Widget              cb_widget;
     XMObject*           cb_object;
};

  extern void      cb_associate     (Widget, XMObject*);
  extern void      cb_remove        (Widget);
  extern XMObject* cb_locate_object (Widget);
  extern XMObject* WindowToObject   (Display*, Window);
  extern void UnmanageChildren (XMObjectList, Cardinal);
  extern void ManageChildren (XMObjectList, Cardinal);


class XMObject {
friend class XMMrm ;

protected :                     // derived classes can access these fields
//     static Arg args[100];      // arguments array to be passed to Motif
    static Arg* args;          // arguments array to be passed to Motif
     static int args_size;      // size of arguments buffer set by XMApplicationShell
     static int args_count;     // args count to be passed to Motif
     static int immediate;      // global flag to indicate whether 
                                // to XtSetValues immediately
     Widget w;                  // widget field to be used by the derived
                                // classes, passed to Motif routines
     // ****CONSTRUCTORS****
     XMObject ();

 public :
     // ****DESTRUCTOR****
     ~XMObject ();

     // ****METHODS TO SET THE Object RESOURCES****
     void   set_entry_destroyCallback (XtCallbackProc, caddr_t);

     // ****METHODS TO NEW MOTIF++ FUNCTIONALITY****
     void   set_immediate_ON          ();
     void   set_immediate_OFF         ();
     void   start_transaction         ();
     void   end_transaction           ();
     void   set                       ();
     void   get                       ();
     Widget get_widget                () {return w;}

     // ****TOOLKIT INTRINSIC COVER FUNCTIONS****
     void AddCallback        (String, XtCallbackProc, caddr_t);
     void AddCallbacks       (String, XtCallbackList);
     void AddEventHandler    (EventMask, Boolean, XtEventHandler, caddr_t);
     void AddGrab            (Boolean, Boolean);
     void AddRawEventHandler (EventMask, Boolean, XtEventHandler, caddr_t);
     XtAppContext ApplicationContext  ();
     void AugmentTranslations (XtTranslations);
     EventMask BuildEventMask  ();
//     Boolean CallAcceptFocus   (Time*);
     void CallCallbacks        (String, caddr_t);
     void CallbackPopdown      (caddr_t, caddr_t);
     void CallbackNone         (caddr_t, caddr_t);
     void CallbackNonexclusive (caddr_t, caddr_t);
     void CallbackExclusive    (caddr_t, caddr_t);
     void Configure            (Position, Position, Dimension,
                                Dimension, Dimension);
     void Convert              (String, XrmValuePtr, String, XrmValuePtr);
     void CreateWindow         (u_int, Visual*,
                                XtValueMask, XSetWindowAttributes*);
     void DisownSelection (Atom, Time);
     void GetApplicationResources (caddr_t, XtResourceList,
                                   Cardinal, ArgList, Cardinal);
     GC   GetGC (XtGCMask, XGCValues*);
     void GetSelectionValue (Atom, Atom, XtSelectionCallbackProc,caddr_t,Time);
//     void GetSelectionValueIncremental (Atom, Atom, 
//                                        XtSelectionIncrCallbackProc,
//                                        XtCancelSelectionCallbackProc,
//                                        caddr_t, Time);
     void GetSelectionValues (Atom, Atom*, int, XtSelectionCallbackProc,
                              XtPointer*, Time);
//     void GetSelectionValuesIncremental (Atom, Atom*, int,
//                                         XtSelectionIncrCallbackProc,
//                                         XtCancelSelectionCallbackProc,
//                                         caddr_t, Time);
     void GetSubresources (caddr_t, String, String, 
                           XtResourceList, Cardinal, ArgList, Cardinal);
     void GetValues (ArgList, Cardinal);
     void GrabKey (KeyCode, u_int, Boolean, int, int);
     int GrabKeyboard (Boolean, int, int, Time);
     XtCallbackStatus HasCallbacks (String);
     void InstallAccelerators (XMObject*);
     void InstallAllAccelerators (XMObject*);
     Boolean IsRealized ();
     Boolean IsSensitive ();
     XtGeometryResult MakeGeometryRequest (XtWidgetGeometry*,                                                              XtWidgetGeometry*);
     XtGeometryResult MakeResizeRequest (Dimension, Dimension,
                                         Dimension*, Dimension*);
     void Manage ();
     void Map ();
     void Move (Position, Position);
     XMObject* NameToWidget (String);
     void OverrideTranslations (XtTranslations);
     Boolean OwnSelection (Atom, Time, XtConvertSelectionProc, 
                           XtLoseSelectionProc, XtSelectionDoneProc);
//     Boolean OwnSelectionIncremental (Atom, Time,
//                                   XtConvertSelectionProc, 
//                                   XtLoseSelectionProc, XtSelectionDoneProc,
//                                   XtCancelConvertSelectionProc, caddr_t);
     void Popdown ();
     void Popup (XtGrabKind);
     XtGeometryResult QueryGeometry (XtWidgetGeometry*, XtWidgetGeometry*);
     void Realize      ();
     void ReleaseGC (GC);
     void RemoveAllCallbacks (String);
     void RemoveCallback (String, XtCallbackProc, caddr_t);
     void RemoveCallbacks (String, XtCallbackList);
     void RemoveEventHandler (EventMask, Boolean, XtEventHandler, caddr_t);
     void RemoveGrab ();
     void RemoveRawEventHandler (EventMask, Boolean, XtEventHandler, caddr_t);
     void Resize (Dimension, Dimension, Dimension);
     void ResizeWindow (Dimension, Dimension);
     void SetKeyboardFocus (XMObject*);
     void SetMappedWhenManaged (Boolean);
     void SetSensitive (Boolean);
     void SetValues (ArgList, Cardinal);
     void TranslateCoords (Position, Position, Position*, Position*);
     void UngrabKey (KeyCode, u_int);
     void UngrabKeyboard (Time);
     void UninstallTranslations ();
     void Unmanage ();
     void Unmap ();
     void Unrealize ();

     Boolean IsManaged ();
     Display* display ();
     Screen* screen ();
     Window window ();
     XMObject* Parent ();
     Boolean IsComposite ();
};

#endif     // XMObject_hh

// dont add stuff after this endif
