/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
static char rcsid[] = "$Header: XMString.cc,v 1.1 89/12/11 12:46:10 kseethar Exp $";
/*
//-----------------------------------------------------------------------------
//
// $Source: /usr/proj/grl/motifplb/design_review_1_efforts/lib_1/XMString.cc,v $
// $Revision: 1.1 $
// $State: Exp $
// $Author: kseethar $
// $Date: 89/12/11 12:46:10 $
// $Locker:  $
//
// $Log:	XMString.cc,v $
Revision 1.1  89/12/11  12:46:10  kseethar
Initial revision


//-----------------------------------------------------------------------------
*/

#include "XMString.hh"

// ---------------------------------------------------------------------------
     XMString::XMString ()
// ---------------------------------------------------------------------------

{
}


// ---------------------------------------------------------------------------
     XMString::~XMString ()                            // XmStringFree
// ---------------------------------------------------------------------------

{
 XmStringFree (s_s);
}


// ---------------------------------------------------------------------------
     XMString::XMString (char* text)
// ---------------------------------------------------------------------------

{
 s_s = XmStringCreateLtoR (text, (char *) XmSTRING_DEFAULT_CHARSET);    
}


// ---------------------------------------------------------------------------
     XMString::XMString (char* text, XmStringCharSet charset, Boolean LtoR = False)
// ---------------------------------------------------------------------------

{
 if (LtoR)
    s_s = XmStringCreateLtoR (text, charset);    
 else
    s_s = XmStringCreate (text, charset);
}


// ---------------------------------------------------------------------------
     XMString::XMString (XmStringDirection d)
// ---------------------------------------------------------------------------

{
 s_s = XmStringDirectionCreate (d);
}


// ---------------------------------------------------------------------------
     XMString::XMString (char* text, XmStringCharSet charset, XmStringDirection d,
                          Boolean separator) 
// ---------------------------------------------------------------------------

{
 s_s = XmStringSegmentCreate (text, charset, d, separator);
}



// ---------------------------------------------------------------------------
     XMString::XMString (Boolean separator)
// ---------------------------------------------------------------------------
{
if (separator) s_s = XmStringSeparatorCreate ();
}


// ---------------------------------------------------------------------------
     Dimension XMString::Baseline      (XMFontList* fl)
// ---------------------------------------------------------------------------

{
 return (XmStringBaseline (fl->get_fontlist(), s_s));
}


// ---------------------------------------------------------------------------
     Boolean   XMString::ByteCompare   (XMString* s) 
// ---------------------------------------------------------------------------

{
 return (XmStringByteCompare (s_s, s->get_string ()));
}


// ---------------------------------------------------------------------------
     Boolean   XMString::Compare       (XMString* s)
// ---------------------------------------------------------------------------

{
 return (XmStringCompare (s_s, s->get_string ()));
}


// ---------------------------------------------------------------------------
     XMString XMString::Concat        (XMString* s)
// ---------------------------------------------------------------------------

{
 XMString temp ("");

 temp.s_s = XmStringConcat (s_s, s->get_string ());
 return (temp);

}


// ---------------------------------------------------------------------------
     XMString XMString::Copy          ()
// ---------------------------------------------------------------------------

{
 XMString temp ("");

 temp.s_s = XmStringCopy (s_s);
 return (temp);

}


// ---------------------------------------------------------------------------
     void      XMString::Draw  (Display* d, Window w, XMFontList* fl, GC gc, Position x, Position y,
                                Dimension wid, Byte alignment, Byte layout_direction,
                                XRectangle* clip)
// ---------------------------------------------------------------------------

{
 XmStringDraw (d, w, fl->get_fontlist(), s_s, gc, x, y, wid, alignment, layout_direction, clip);
}


// ---------------------------------------------------------------------------
     void      XMString::DrawImage  (Display* d, Window w, XMFontList* fl, GC gc, Position x, Position y,
                                     Dimension wid, Byte alignment, Byte layout_direction,
                                     XRectangle* clip)
// ---------------------------------------------------------------------------

{
 XmStringDrawImage (d, w, fl->get_fontlist(), s_s, gc, x, y, wid, alignment, layout_direction, clip);
}


// ---------------------------------------------------------------------------
     void      XMString::DrawUnderline (Display* d, Drawable drawable, XMFontList* fl, GC gc, 
                                        Position x, Position y, Dimension wid, Byte alignment, 
                                        Byte layout_direction, XRectangle* clip, XMString* underline)
// ---------------------------------------------------------------------------

{
 XmStringDrawUnderline (d, drawable, fl->get_fontlist(), s_s, gc, x, y, wid, alignment, layout_direction, clip, 
                        underline->get_string ());
}


// ---------------------------------------------------------------------------
     Boolean   XMString::Empty         ()
// ---------------------------------------------------------------------------

{
 return (XmStringEmpty (s_s));
}


// ---------------------------------------------------------------------------
     void      XMString::Extent        (XMFontList* fl, Dimension* wid, Dimension* height )
// ---------------------------------------------------------------------------

{
 XmStringExtent (fl->get_fontlist(), s_s, wid, height);
}


// ---------------------------------------------------------------------------
     Boolean   XMString::GetLtoR       (XmStringCharSet charset, char** text)
// ---------------------------------------------------------------------------

{
 return (XmStringGetLtoR (s_s, charset, text));
}


// ---------------------------------------------------------------------------
     Dimension XMString::Height        (XMFontList* fl)
// ---------------------------------------------------------------------------

{
 return (XmStringHeight (fl->get_fontlist(), s_s));
}


// ---------------------------------------------------------------------------
     Boolean   XMString::InitContext   (XmStringContext* context)
// ---------------------------------------------------------------------------

{
 return (XmStringInitContext (context, s_s));
}


// ---------------------------------------------------------------------------
     int       XMString::Length        ()
// ---------------------------------------------------------------------------

{
 return (XmStringLength (s_s));
}


// ---------------------------------------------------------------------------
     int       XMString::LineCount     ()
// ---------------------------------------------------------------------------

{
 return (XmStringLineCount (s_s));
}


// ---------------------------------------------------------------------------
     XMString XMString::NConcat       (XMString* s, int n)
// ---------------------------------------------------------------------------

{

 XMString temp ("");

 temp.s_s = XmStringNConcat (s_s, s->get_string (), n);
 return (temp);

}


// ---------------------------------------------------------------------------
     XMString XMString::NCopy         (int n)
// ---------------------------------------------------------------------------

{

 XMString temp ("");

 temp.s_s = XmStringNCopy (s_s, n);
 return (temp);

}


// ---------------------------------------------------------------------------
     Dimension XMString::Width         (XMFontList* fl)
// ---------------------------------------------------------------------------

{
 return (XmStringWidth (fl->get_fontlist(), s_s));
}


