/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
#include "XMAppShell.hh"
#include "XMRowColumn.hh"
#include "XMDrawingA.hh"
#include "XMPushB.hh"
#include "XMForm.hh"
#include "XMLabel.hh"
#include "XMArgs.hh"
#include "XMFontList.hh"


DECLARE_ENTRY (activateCB);

void main (unsigned int argc,  char **argv) {
  
  Font               font;
  XMArgs             argss;
  XMRowColumn*       args;
  XMApplicationShell DrawChart  ("main", &argc, argv);
  XMForm             form   (&DrawChart, "form");
  
	args = (XMRowColumn *) &argss;
	args->set_orientation (XmHORIZONTAL);
  XMFontList         FontList (DrawChart.display(), "variable");
  XMRowColumn        mainmenu  (&form, "mainmenu");
	  XMLabel            spacer0   (&mainmenu, "                        ");
	  XMPushButton       Next      (&mainmenu, "Next" );
	  XMPushButton       Plot      (&mainmenu, "Plot" );
	  XMPushButton       Save      (&mainmenu, "Save" );
	  XMPushButton       Quit      (&mainmenu, "Quit" );
          Quit.set_entry_activateCallback (activateCB, NULL);
	  XMLabel            spacer1   (&mainmenu, "        ");
	  XMPushButton       Help      (&mainmenu, "   --==*| Help |*==--" );
	  form.set_topAttachment (&mainmenu, XmATTACH_FORM);
	mainmenu.Manage();

	args = (XMRowColumn *) &argss;
	args->set_orientation (XmVERTICAL);
	args->set_foreground(1);
  XMRowColumn        command      (&form, "command");
	  XMPushButton       TraverseUp   (&command, "Traverse Up");
	  XMPushButton       TraverseDown (&command, "Traverse Down");
	  XMPushButton       Redraw       (&command, "Re Draw ");
	  form.set_leftAttachment   (&command, XmATTACH_FORM);
	  form.set_topAttachment    (&command,XmATTACH_WIDGET);
	  form.set_topWidget        (&command, &mainmenu);
	command.Manage();

  XMDrawingArea      canvas  (&form, "canvas");
	  form.set_topAttachment     (&canvas, XmATTACH_WIDGET);
          form.set_topWidget         (&canvas,&mainmenu);
          form.set_leftAttachment    (&canvas, XmATTACH_WIDGET);
          form.set_leftWidget        (&canvas,&command);
          form.set_rightAttachment   (&canvas, XmATTACH_FORM);
          form.set_bottomAttachment  (&canvas,XmATTACH_FORM);
       canvas.Manage ();

  DrawChart.Realize ();
  XtMainLoop ();
}

ENTRY (activateCB, XMPushButton, Quit, c1, c2);
 exit (0);
   }

