// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "SlidingStatistic.h"
#include <math.h>

SlidingStatistic::SlidingStatistic( int s )
{
    sample = new double [ s ]; 
    maxSamples = s;
    head = 0;
    cached = 0;
}

SlidingStatistic::~SlidingStatistic()
{
    if (maxSamples > 0) {
	delete sample;
    }
}

void
SlidingStatistic::operator+=(double value)
{
    if ( head >= maxSamples ) {
	head = 0;
    }
    if ( n >= maxSamples ) {
	//
	//	Remove the oldest value
	//
	n--;
	x -= sample[head];
	x2 -= (sample[head] * sample[head]);
    }

    sample[ head ] = value;
    head++;

    n ++;
    x += value;
    x2 += (value * value);

    cached = 0;
}

void
SlidingStatistic::reset()
{
    Statistic::reset();
    cached = 0;
    head = 0;
}

void
SlidingStatistic::cacheValues()
{
    minValue = MAXFLOAT;
    maxValue = -MAXFLOAT;
    for ( int i = 0; i < n; i++ ) {
	minValue = (minValue < sample[i]) ? minValue : sample[i];
	maxValue = (maxValue < sample[i]) ? sample[i] : maxValue;
    }
    cached = 1;
}

double
SlidingStatistic::min()
{
    if (!cached) {
	cacheValues();
    }
    return( minValue );
}

double
SlidingStatistic::max()
{
    if (!cached) {
	cacheValues();
    }
    return( maxValue );
}
