// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef SlidingStatistic_h
#define SlidingStatistic_h
#pragma once

#include <Statistic.h>

class SlidingStatistic : public Statistic {
protected:
    double *sample;
    int maxSamples;
    int head;
    char cached;

    virtual void cacheValues();

public:
    
    SlidingStatistic( int samples );

    ~SlidingStatistic();

    virtual void reset();
    virtual void operator+=(double);
    virtual double min();
    virtual double max();
};

#endif SlidingStatistic_h
