#ifndef HEAPPROC_H
#define HEAPPROC_H

/*$Header: HeapProc.h,v 2.204 89/10/07 23:19:42 keith Stab $*/

/* HeapProc.h -- Specification for Process with stack on free storage heap

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892
	January, 1989

Modification History:

$Log:	HeapProc.h,v $
 * Revision 2.204  89/10/07  23:19:42  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/08/30  22:19:53  keith
 * Implement deepenVBase().
 * 
 * Revision 2.203  89/08/12  23:40:51  keith
 * Pre-release
 * Add BUG_38 work-around.
 * 
 * Revision 2.202.1.3  89/07/04  19:39:11  keith
 * Add process to Scheduler runlist in FORK().
 * 
 * Revision 2.202.1.2  89/07/03  16:14:25  keith
 * Make storer() shouldNotImplement().
 * 
 * Revision 2.202.1.1  89/07/01  21:54:14  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:11  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:13:54  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  22:57:35  keith
 * Make all constructors non-inline.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:55  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:55  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:09  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:58:15  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:57  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:45  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:58  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.11  89/01/17  11:41:56  keith
 * Initial version.
 * 
*/

#include "Process.h"

class HeapProc: public Process {
	DECLARE_MEMBERS(HeapProc);
	unsigned long stack_size;	// size of stack in words
	void setupStack();
protected:
	HeapProc(const char* name, stackTy* bottom, int priority =0, unsigned long size =1024);
	virtual void switchContext(Process*);
	virtual void switchFrom(HeapProc*);
	virtual void switchFrom(StackProc*);
	bool FORK() {
		add();		// add this process to Scheduler runlist
		if (_SETJMP(env) == 0) {
			setupStack();
			return YES;
		}
		else return NO;
	}
#ifndef BUG_38
// internal <<AT&T C++ Translator 2.00 06/30/89>> error: bus error (or something nasty like that)
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd&) const	{ shouldNotImplement("storer"); }
	virtual	void storer(OIOout&) const	{ shouldNotImplement("storer"); }
public:
	virtual	void deepenShallowCopy()	{ shouldNotImplement("deepenShallowCopy"); }
#endif
public:
	~HeapProc();
	virtual unsigned size() const;
};

#endif
