/* Test class IdentDict

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	iddictio.c,v $
 * Revision 2.204  89/10/07  23:50:32  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:11  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:22:09  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/11  22:24:43  keith
 * Update for R2.0.
 * 
 * Revision 2.200.1.1  89/05/10  22:55:29  keith
 * Modify for abstract OIO classes.
 * 
 * Revision 2.200  89/04/24  17:34:01  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:20:39  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.1  89/02/08  14:04:24  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.0  88/03/29  13:26:57  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:45  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: iddictio.c,v 2.204 89/10/07 23:50:32 keith Stab $";

#include "Assoc.h"
#include "Bitset.h"
#include "IdentDict.h"
#include "OrderedCltn.h"
#include "Point.h"
#include "Rectangle.h"
#include "Set.h"
#include "SortedCltn.h"
#include "Stack.h"
#include "String.h"
#include "OIOnih.h"

Object* testStore()
{
	Bitset& bitset = *new Bitset(Bitset::bit(4)|Bitset::bit(6));
	IdentDict& iddict = *new IdentDict;
	OrderedCltn& orderedcltn = *new OrderedCltn;
	Point& point = *new Point(1,2);
	Rectangle& rect = *new Rectangle(0,1,2,3);
	Set& set = *new Set;
	SortedCltn& sortedcltn = *new SortedCltn;
	Stack& stack = *new Stack;
	String& str = *new String("Hello, world!");
	orderedcltn.add(point); orderedcltn.add(rect); orderedcltn.add(str);
	stack.push(bitset); stack.push(orderedcltn);
	sortedcltn.add(*new String("Huey"));
	sortedcltn.add(*new String("Dewey"));
	sortedcltn.add(*new String("Louie"));
	iddict.add(*new Assoc(orderedcltn,point));
	iddict.add(*new Assoc(bitset,rect));
	iddict.add(*new Assoc(sortedcltn,stack));
	set.add(orderedcltn);
	set.add(stack);
	set.add(sortedcltn);
	set.add(iddict);
	OrderedCltn& monster = *new OrderedCltn;
	monster.add(set); monster.add(*set.deepCopy());
	return &monster;
}

#include <fcntl.h>
#include <osfcn.h>

main()
{
	cout << "Test storeOn\n";
	ostream* out = new ostream(creat("iddicta",0664));
	Object* a = testStore();
	a->storeOn(OIOnihout(*out));
	delete out;

	cout << "Test readFrom\n";
	istream* in = new istream(open("iddicta",O_RDONLY));
	Object* b = Object::readFrom(OIOnihin(*in));
	delete in;
	cout << "*** object stored:\n" << *a << endl;
	cout << "*** object read:\n" << *b << endl;
	out = new ostream(creat("iddictb",0664));
	b->storeOn(OIOnihout(*out));
	delete out;
}
