/* Test class IdentDict

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	identdict.c,v $
 * Revision 2.204  89/10/07  23:50:34  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:14  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:22:11  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:24:46  keith
 * Update for R2.0.
 * 
 * Revision 2.200  89/04/24  17:34:07  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:20:42  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/08  14:04:26  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.1  88/05/30  09:49:07  keith
 * Update for new dumpOn()/printOn() format.
 * 
 * Revision 2.0  88/03/29  13:27:00  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:46  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: identdict.c,v 2.204 89/10/07 23:50:34 keith Stab $";

#include "Point.h"
#include "IdentDict.h"
#include "Assoc.h"
#include "AssocInt.h"
#include "Bag.h"
#include "OrderedCltn.h"

main()
{
	cout << "\nTest class IdentDict\n";
	IdentDict d(16);
	Point a(1,1), b(1,2), c(1,3);
	AssocInt asc(c,3);
	d.add(*new AssocInt(a,1));
	d.add(*new Assoc(b,*new Point(2,2)));
	d.add(asc);
	cerr << "d = ";  d.dumpOn(cerr);
	cout << "d.atKey(a): " << *(d.atKey(a)) << endl;
	cout << "d.includesKey(Point(1,1)): " << d.includesKey(Point(1,1)) << endl;
	d.atKey(a,*new Integer(0));
	cout << "d.atKey(a): " << *(d.atKey(a)) << endl;
	cout << "d.includesAssoc(asc): " << d.includesAssoc(asc) << endl;
	cout << "d.includesKey(" << (*asc.key()) << "): " << d.includesKey(*asc.key()) << endl;
	cout << "d.keyAtValue(Integer(0)) = " << *d.keyAtValue(Integer(0)) << endl;
	d.removeKey(c);
	cout << "d.includesAssoc(asc): " << d.includesAssoc(asc) << endl;
	cout << "d.includesKey(" << (*asc.key()) << "): " << d.includesKey(*asc.key()) << endl;
	cout << "d.asBag: " << d.asBag() << endl;
	OrderedCltn keys,vals;
	cout << "d.addKeysTo(keys): " << d.addKeysTo(keys) << endl;
	cout << "d.addValuesTo(vals): " << d.addValuesTo(vals) << endl;
}
