/* Test class LinkedList

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	linkedlist.c,v $
 * Revision 2.204  89/10/07  23:50:48  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/12  23:17:14  keith
 * Pre-release
 * Add test of addAfter() and removeAll().
 * 
 * Revision 2.202  89/06/15  21:18:23  keith
 * Replace test of at() with test of operator[]() since
 * at() can no longer be implemented.
 * 
 * Revision 2.201  89/05/12  13:22:35  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:24:57  keith
 * Update for R2.0.
 * 
 * Revision 2.200  89/04/24  17:34:27  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:21:08  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.1  89/02/08  14:04:37  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.0  88/03/29  13:27:14  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:50  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: linkedlist.c,v 2.204 89/10/07 23:50:48 keith Stab $";

#include "Point.h"
#include "LinkedList.h"
#include "LinkOb.h"
#include "Set.h"

main()
{
	cout << "\nTest class LinkedList\n";
	Point A(1,1);
	Point B(1,2);
	Point C(1,3);
	Point D(1,3);
	LinkOb bA(A);
	LinkOb bB(B);
	LinkOb bC(C);
	LinkOb bD(D);
	LinkedList b;
	b.add(bA);
	b.add(bB);
	b.add(bC);
	b.add(bD);
	LinkedList& c = *LinkedList::castdown(b.deepCopy());
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	cout << "b[3]: " << *b[3] << endl;
	b.reSize(30);
	cout << "b.includes(C): " << b.includes(C) << endl;
	cout << "c == b: " << (c==b) << endl;
	b.addFirst(*new LinkOb(*new Point(1,0)));
	b.addLast(*new LinkOb(*new Point(1,19)));
	cout << "b = " << b << endl;
	b.addAll(c);
	cout << "b = " << b << endl;
	b.remove(*b[1]);
	cout << "b.includes(A): " << b.includes(A) << endl;
	cout << "b = " << b << endl;
	cout << "c == b: " << (c==b) << endl;
	cout << "b.indexOf(D): " << b.indexOf(D) << endl;
	cout << "c = " << c << endl;
	DO(c,Object,ob) cout << *ob; OD
	cout << endl;
	cout << "c.size() = " << c.size() << endl;
	LinkOb::castdown(c[1])->value(A);
	cout << "c = " << c << endl;
	while (c.size() != 0) {
		c.remove(*c.first());
		cout << "c = " << c << endl;
	}
	cout << "b.asSet(): " << (b.asSet()) << endl;
	b.removeAll();
	b.add(bA);
	b.add(bC);
	b.addAfter(bA,bB);
	b.addAfter(bC,bD);
	D = Point(1,4);
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	cout << "b.size(): " << b.size() << endl;
	b.removeAll();
}
