#ifndef	VECTOR_H
#define	VECTOR_H

/* Vector.h -- declarations for generic vector objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	May, 1986


Function:


Modification History:

$Log:	Vector.h,v $
 * Revision 2.204  89/10/08  09:43:02  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/14  11:45:45  ted
 * Made constructor public
 * 
 * Revision 2.202  89/06/28  23:33:57  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/28  22:42:45  keith
 * Delete copy constructor.
 * Delete member variable "reserved".
 * Delete readFrom() constructors.
 * 
 * Revision 2.201.1.1  89/06/02  11:35:29  keith
 * Add VIRTUAL keyword for MI.
 * 
 * Revision 2.201  89/05/12  13:46:43  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/03  23:36:11  keith
 * Utilize abstract classes.
 * 
 * Revision 2.122  89/05/03  23:33:25  keith
 * 
 * 
 * Revision 2.3  89/02/08  14:22:44  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.2  88/07/17  12:49:07  keith
 * Update for revised NIHCL Object I/O.
 * 
 * Revision 2.1  88/06/04  23:04:18  keith
 * Add default argument "cout" to printOn().
 * Add Vector::Vector(const Vector&).
 * Add shallowCopy().
 * 
 * Revision 2.0  88/03/29  21:56:38  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  09:47:11  keith
 * Initial revision
 * 
	
*/

#include "Object.h"

#include <math.h>

typedef double (*mathFunTy)(double);

class BitVec;
class ByteVec;
class ComplexVec;
class DoubleVec;
class FloatVec;
class IntVec;
class LongVec;
class ShortVec;

class Vector : public VIRTUAL Object {
	DECLARE_MEMBERS(Vector);
protected:
	unsigned n;		// number of elements in vector
protected:
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Vector(unsigned len=0)	{ n = len; }
	unsigned length() const	{ return n; }
	void emptyErr(const char* fname) const;
	virtual unsigned capacity() const;
	virtual void	deepenShallowCopy();	// {}
	virtual void	free();			// {}
	virtual unsigned hash() const = 0;
	virtual bool isEqual(const Object&) const = 0;
	virtual void printOn(ostream& strm =cout) const = 0;
	virtual unsigned size() const;
friend	void lengthErr(const Vector&, const Vector&);
private:			// shouldNotImplement()
	int compare(const Object&) const;
};

#endif
