------------------------------------------------------------
-- This package is specific to the ICC Ada compiler and
-- reflects the preferences of the author of the c2ada
-- translator.  You will need to port this package to the
-- Ada compiler you're currently using.
------------------------------------------------------------

with LOW_TYPES;
with SYSTEM;

package C is

   ---------------------------------------------------------
   -- Predefined Builtin Types
   ---------------------------------------------------------
   subtype void is low_types.int8;

   subtype char is low_types.int8;
   subtype short is low_types.int16;
   subtype int is low_types.int32;
   subtype long is low_types.int32;

   subtype unsigned_char is low_types.uint8;
   subtype unsigned_short is low_types.uint16;
   subtype unsigned_int is low_types.uint32;
   subtype unsigned_long is low_types.uint32;

   subtype float is standard.short_float;
   subtype double is standard.float;


   ---------------------------------------------------------
   -- Predefined Access Types
   ---------------------------------------------------------
   subtype void_p is low_types.int8_p;
   subtype char_p is low_types.int8_p;
   subtype short_p is low_types.int16_p;
   subtype int_p is low_types.int32_p;
   subtype long_p is low_types.int32_p;

   subtype unsigned_char_p is low_types.uint8_p;
   subtype unsigned_short_p is low_types.uint16_p;
   subtype unsigned_int_p is low_types.uint32_p;
   subtype unsigned_long_p is low_types.uint32_p;

   type float_p is access float;
   type double_p is access double;

   subtype pointer is system.address;
   subtype function_pointer is system.address;


   ---------------------------------------------------------
   -- Predefined Array Types
   ---------------------------------------------------------
   type char_vec is array(c.int range <>) of c.char;
   type short_vec is array(c.int range <>) of c.short;
   type int_vec is array(c.int range <>) of c.int;
   type long_vec is array(c.int range <>) of c.long;

   type unsigned_char_vec is array(c.int range <>) of c.unsigned_char;
   type unsigned_short_vec is array(c.int range <>) of c.unsigned_short;
   type unsigned_int_vec is array(c.int range <>) of c.unsigned_int;
   type unsigned_long_vec is array(c.int range <>) of c.unsigned_long;

   type float_vec is array(c.int range <>) of c.float;
   type double_vec is array(c.int range <>) of c.double;

   type pointer_vec is array(c.int range <>) of c.pointer;
   type function_pointer_vec is array(c.int range <>) of c.function_pointer;


   ---------------------------------------------------------------------------
   -- The following types are used to represent C bit fields
   ---------------------------------------------------------------------------
   type bit1  is range 0 .. 2**1-1;
   type bit2  is range 0 .. 2**2-1;
   type bit3  is range 0 .. 2**3-1;
   type bit4  is range 0 .. 2**4-1;
   type bit5  is range 0 .. 2**5-1;
   type bit6  is range 0 .. 2**6-1;
   type bit7  is range 0 .. 2**7-1;
   type bit8  is range 0 .. 2**8-1;
   type bit9  is range 0 .. 2**9-1;
   type bit10 is range 0 .. 2**10-1;
   type bit11 is range 0 .. 2**11-1;
   type bit12 is range 0 .. 2**12-1;
   type bit13 is range 0 .. 2**13-1;
   type bit14 is range 0 .. 2**14-1;
   type bit15 is range 0 .. 2**15-1;
   type bit16 is range 0 .. 2**16-1;
   type bit17 is range 0 .. 2**17-1;
   type bit18 is range 0 .. 2**18-1;
   type bit19 is range 0 .. 2**19-1;
   type bit20 is range 0 .. 2**20-1;
   type bit21 is range 0 .. 2**21-1;
   type bit22 is range 0 .. 2**22-1;
   type bit23 is range 0 .. 2**23-1;
   type bit24 is range 0 .. 2**24-1;
   type bit25 is range 0 .. 2**25-1;
   type bit26 is range 0 .. 2**26-1;
   type bit27 is range 0 .. 2**27-1;
   type bit28 is range 0 .. 2**28-1;
   type bit29 is range 0 .. 2**29-1;
   type bit30 is range 0 .. 2**30-1;
   type bit31 is range 0 .. 2**31-1;

   for bit1'size use 1;
   for bit2'size use 2;
   for bit3'size use 3;
   for bit4'size use 4;
   for bit5'size use 5;
   for bit6'size use 6;
   for bit7'size use 7;
   for bit8'size use 8;
   for bit9'size use 9;
   for bit10'size use 10;
   for bit11'size use 11;
   for bit12'size use 12;
   for bit13'size use 13;
   for bit14'size use 14;
   for bit15'size use 15;
   for bit16'size use 16;
   for bit17'size use 17;
   for bit18'size use 18;
   for bit19'size use 19;
   for bit20'size use 20;
   for bit21'size use 21;
   for bit22'size use 22;
   for bit23'size use 23;
   for bit24'size use 24;
   for bit25'size use 25;
   for bit26'size use 26;
   for bit27'size use 27;
   for bit28'size use 28;
   for bit29'size use 29;
   for bit30'size use 30;
   for bit31'size use 31;

end C;
