/*
 * $Id: int.h,v 2.0 1992/09/23 12:24:58 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All rights reserved.
 *
 */

#ifndef _INT_
#define _INT_

/* Macros for inline expansion */

/* Bodies of Macro for inline expansion */

#define _int_add(x,y)		((x) + (y))
#define _int_sub(x,y)		((x) - (y))
#define _int_mul(x,y)		((x) * (y))
#define _int_minus(x)		(-(x))
#define _int_abs(x)		(((x) > 0) ? (x) : -(x))
#define _int_max(x,y)		(((x) > (y)) ? (x) : (y))
#define _int_min(x,y)		(((x) < (y)) ? (x) : (y))
#define _int_lt(x,y)		((x) <  (y))
#define _int_le(x,y)		((x) <= (y))
#define _int_ge(x,y)		((x) >= (y))
#define _int_gt(x,y)		((x) >  (y))
#define _int_equal(x,y)		((x) == (y))
#define _int_similar(x,y)	((x) == (y))
#define _int_copy(x)		(x)

#define _int_div(tx,ty,ts)	((ts = (ty > 0) ? 1 : -1),\
				 (ty = abs(ty)),\
				 ((tx >= 0) ? ((tx / ty) * ts) :\
				  (((-tx + ty - 1) / ty) * (-ts))))
#define _int_mod(tx,ty,ta)	((ty = abs(ty)),\
				 ((tx >= 0) ? (tx % ty) :\
				  ((ta = ty - ((-tx) % ty)),\
				   ((ta == ty) ? 0 : ta))))

/* Flags Which catch the signal raised by Macro for inline expansion */

#define _int_zero_divide(x)	((x) == 0)

#endif /* _INT_ */
