/*
 * $Id: type.h,v 2.0 1992/09/23 12:31:57 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All rights reserved.
 *
 */

#ifndef _TYPE_
#define _TYPE_

#include <stdio.h>

typedef int elt;		/* unknown type (but 4byte) */

/* Built-in Types and Type Generators */

#include <blt-in/bool.h>
#include <blt-in/null.h>
#include <blt-in/int.h>
#include <blt-in/real.h>
#include <blt-in/char.h>
#include <blt-in/string.h>
#include <blt-in/array.h>
#include <blt-in/sequence.h>
#include <blt-in/record.h>
#include <blt-in/struct.h>
#include <blt-in/oneof.h>
#include <blt-in/variant.h>
#include <blt-in/proctype.h>
#include <blt-in/itertype.h>
#include <blt-in/any.h>

/* Other Standard Libraries */

#include <blt-in/file_name.h>
#include <blt-in/stream.h>
#include <blt-in/istream.h>
#include <blt-in/wvec.h>

/* Used by the system */

typedef elt cvt;
typedef elt clus;		/* user-defined cluster */
typedef char *type_parm;	/* type parameter name */

typedef struct {
    proctype *oplist;		/* $@%Q%i%a%?$K0MB8$7$?8F$S@h$N%j%9%H(J */
    int local_own_id;		/* $@%m!<%+%k$J(J own $@JQ?t$N(J id */
    int clus_own_id;		/* $@%/%i%9%?(J  own $@JQ?t$N(J id */
    elt *vparms;		/* $@7?%Q%i%a!<%?0J30$N%Q%i%a%?$N%j%9%H(J */
} param_info;

#endif /* _TYPE_ */
