/* 
 * $Id: builtin_param.c,v 2.0 1992/09/23 08:39:32 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/* fill_copy = proc(lb, cnt: int, elem: T) returns(array[T])
 *						signals(negative_size)
 *				where T has copy: proctype(T) returns(T) */

int array_fill_copy(int (*(op_list[]))(), int lb, int cnt, elt elem)
{
  int i;			/* loop control */
  array x;
  elt elem_copy;
  /*
   *	if cnt < o then signal nagative_size end 
   */
  if (cnt < 0) {
    signame = "negative_size";
    return SIG;
  }
  /*
   *	x := array[T]$predict(lb, cnt)
   */
  if (array_predict(lb, cnt) == SIG) {
    goto sighandler;
  }
  x = (array) retval_area[0];
  /*
   *	for i: int in int$from_to(1, cnt) do ...
   */
  for (i = 1; i <= cnt; i++) {
    /*
     *	array[T]$addh(x, T$copy(elem))
     */
    if ((*(op_list[0]))(elem) == SIG) {
      goto sighandler;
    }
    elem_copy = retval_area[0];
    if (array_addh(x, elem_copy) == SIG) {
      goto sighandler;
    }
  }
  /* return(x) */
  retval_area[0] = (elt) x;
  return RET;
  /* exception handler */
 sighandler:
  out_handler();
  return SIG;
}

/* copy = proc(a: array[T]) returns(array[T])
 *	where T has copy: proctype(T) returns(T)	*/

int array_copy(int (*(op_list[]))(), array x)
{
  int i;			/* loop control */
  array y;
  int x_low, x_high;
  elt x_ith;
  
  /* y := array[T]$copy1(x) */
  if (array_copy1(x) == SIG) {
    goto sighandler;
  }
  y = (array) retval_area[0];
  
  /* for i: int in x!indexes() do ... */
  if (array_low(x) == SIG) {
    goto sighandler;
  }
  x_low = retval_area[0];
  if (array_high(x) == SIG) {
    goto sighandler;
  }
  x_high = retval_area[0];
  
  for (i = x_low; i <= x_high; i++) {
    
    /* y[i] := T$copy(x[i]) */
    if (array_fetch(x, i) == SIG) {
      goto sighandler;
    }
    x_ith = retval_area[0];
    if ((*(op_list[0]))(x_ith) == SIG) {
      goto sighandler;
    }
    if (array_store(y, i, retval_area[0]) == SIG) {
      goto sighandler;
    }
  }
  /* return(y) */
  retval_area[0] = (elt) y;
  return RET;
  
  /* exception handler */
 sighandler:
  out_handler();
  return SIG;
}

/* similar = proc(a1, a2: array[T]) returns(bool)
 *	where T has similar: proctype(T, T) returns(bool)	*/

int array_similar(int (*(op_list[]))(), array a1, array a2)
{
  return(array_similar_body(op_list, a1, a2));
}

/* similar1 = proc(a1, a2: array[T]) returns(bool)
 *	where T has equal: proctype(T, T) returns(bool)	*/

int array_similar1(int (*(op_list[]))(), array a1, array a2)
{
  return
(array_similar_body(op_list, a1, a2));
}

int array_similar_body(int (*(op_list[]))(), array a1, array a2)
{
  int i;			/* loop control */
  int a1_low, a2_low, a1_size, a2_size;
  elt a1_ith, a2_ith;
  
  /* if a1!low() ~= a2!low() then return(false) end */
  if (array_low(a1) == SIG) goto sighandler;
  a1_low = retval_area[0];

  if (array_low(a2) == SIG) goto sighandler;
  a2_low = retval_area[0];

  if (a1_low != a2_low) {
    retval_area[0] = (elt) FALSE;
    return RET;
  }
  
  /* if a1!size() ~= a2!size() then return(false) end */
  if (array_size(a1) == SIG) goto sighandler;
  a1_size = retval_area[0];

  if (array_size(a2) == SIG) goto sighandler;
  a2_size = retval_area[0];

  if (a1_size != a2_size) {
    retval_area[0] = (elt) FALSE;
    return RET;
  }
  
  /* for i: int in a1!indexes() do ... */
  for (i = a1_low; i <= a1_low + a1_size - 1; i++) {
    /* if ~a1[i]!equal(a2[i]) then return(false) end */
    
    if (array_fetch(a1, i) == SIG) goto sighandler;
    a1_ith = retval_area[0];
    if (array_fetch(a2, i) == SIG) goto sighandler;
    a2_ith = retval_area[0];

    if ((*(op_list[0]))(a1_ith, a2_ith) == SIG) goto sighandler;

    if (retval_area[0] == FALSE) {
      return RET;
    }
  }
  
  /* return(true) */
  retval_area[0] = (elt) TRUE;
  return RET;
  
  /* exception handler */
 sighandler:
  out_handler();
  return SIG;
}

/*  encode = proc(a: array[t], s: istream) signals(not_possible(string))
 *		where t has encode: proctype(t, istream)
 *				    signals(not_possible(stirng))
 *	modifies  s.
 *	effects  Writes an encoding of a onto the istream s. 		*/

int array_encode(int (*(op_list[]))(), array a, istream s)
{
  int size, base;
  int i;
  int id;

  /* check if this array has been already encoded */
  istream_check_history(s, a);
  id = (int) retval_area[0];
  if (istream_puti(s, id) == SIG) {
    return(SIG);
  }
  if (id != NOT_YET) {
    return(RET);
  }
  
  /* encode array */
  size = a->size;
  if (istream_puti(s, a->low) == SIG || istream_puti(s, size) == SIG) {
    return(SIG);
  }
  base = a->base;
  for (i = base; i < base + size; i++) {
    if ((*(op_list[0]))(a->buf[i], s) ==SIG)
      return(SIG);
  }	    
  return(RET);
}

/*  decode = proc(s: istream) returns(array[t])
 *			      signals(end_of_file, not_possible(string))
 *		where t has decode: proctype(istream) returns(t)
 *				    signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.		*/

int array_decode(int (*(op_list[]))(), istream s)
{
  int low, size;
  int i;
  array a;
  int id;
  
  /* check if the same object has been decoded already */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  id = (int) retval_area[0];
  if (id != NOT_YET) {
    int res;
    res = istream_get_obj(s, id);
    if (res == SIG && strcmp(signame, "bounds") == 0) {
      /* this can't happen... */
      signame = "not_possible";
      sigarg_area[0] = (elt) "wrong id";
    }
    return(res);
  }

  /* get low bound and size (size is checked) */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  low = (int) retval_area[0];
  
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  size = (int) retval_area[0];
  
  if (size < 0) {
    signame = "not_possible";
    sigarg_area[0] = (elt) "bad format";
    return(SIG);
  } 
  
  /* create array object, and add it to history */
  if (size == 0) {
    array_create(low);
  } else {
    array_predict(low, size);
  }
  a = (array) retval_area[0];
  istream_add_history(s, a);
  
  /* get elements */
  for (i = 0; i < size; i++) {
    if ((*(op_list[0]))(s) ==SIG)
      return(SIG);
    array_addh(a, retval_area[0]);
  }
  
  /* completed! */
  retval_area[0] = (elt) a;
  return(RET);
}

/* fill_copy = proc(int,T)returns(sequence[T])signals(negative_size)
 *             where T has copy:proctype(T)returns(T)			 */

int sequence_fill_copy(int (*(op_list[]))(), int cnt, elt elem)
{
  int i;			/* loop control */
  sequence x;
  elt elem_copy;
  
  /* if cnt < o then signal nagative_size end */
  if (cnt < 0) {
    signame = "negative_size";
    return SIG;
  }
  
  /* x := sequence[T]$new() */
  if (sequence_new() == SIG) goto sighandler;
  x = (sequence) retval_area[0];
  
  /* for i: int in int$from_to(1, cnt) do ... */
  for (i = 1; i <= cnt; i++) {
    
    /* x := sequence[T]$addh(x, T$copy(elem) */
    if ((*(op_list[0]))(elem) == SIG) goto sighandler;
    
    elem_copy = retval_area[0];
    if (sequence_addh(x, elem_copy) == SIG) goto sighandler;
    x = (sequence) retval_area[0];
  }
  
  /* return(x) */
  retval_area[0] = (elt) x;
  return RET;
  
  /* exception handler */
 sighandler:
  out_handler();
  return SIG;
}

/* equal = proc(sequence[T],sequence[T])returns(bool)
 *         where T has equal:proctype(T,T)returns(bool) */

int sequence_equal(int (*(op_list[]))(), sequence q1, sequence q2)
{
  int i;			/* loop control */
  int q1_size;
  elt q1_ith, q2_ith;
  
  /* if q1!size() ~= q2!size() then return(false) end */
  if (sequence_size(q1) == SIG) goto sighandler;
  q1_size = retval_area[0];

  if (sequence_size(q2) == SIG) goto sighandler;

  if (retval_area[0] != q1_size) {
    retval_area[0] = FALSE;
    return RET;
  }
  
  /* for i: int in q1!indexes() do ... */
  for (i = 1; i <= q1_size; i++) {
    
    /* if ~q1[i]!equal(q2[i]) then return(false) end */
    if (sequence_fetch(q1, i) == SIG)  goto sighandler;
    q1_ith = retval_area[0];

    if (sequence_fetch(q2, i) == SIG)   goto sighandler;
    q2_ith = retval_area[0];
    
    if ((*(op_list[0]))(q1_ith, q2_ith) == SIG) goto sighandler;
    
    if (retval_area[0] == FALSE) {
      return RET;
    }
  }
  
  /* return(true) */
  retval_area[0] = TRUE;
  return RET;
  
  /* exception handler */
  
 sighandler:
  out_handler();
  return SIG;
}

/* similar = proc(sequence[T],sequence[T])returns(bool)
 *           where T has similar:proctype(T,T)returns(bool)  	 */

int sequence_similar(int  (*(op_list[]))(), sequence q1, sequence q2)
{
  int i;			/* loop control */
  int q1_size;
  elt q1_ith, q2_ith;
  
  /* if q1!size() ~= q2!size() then return(false) end */
  if (sequence_size(q1) == SIG) goto sighandler;
  q1_size = retval_area[0];

  if (sequence_size(q2) == SIG)  goto sighandler;
  if (retval_area[0] != q1_size){
    retval_area[0] = FALSE;
    return RET;
  }
  
  /* for i: int in q1!indexes() do ... */
  for (i = 1; i <= q1_size; i++) {
    
    /* if ~q1[i]!similar(q2[i]) then return(false) end */
    if (sequence_fetch(q1, i) == SIG) goto sighandler;
    q1_ith = retval_area[0];
    if (sequence_fetch(q2, i) == SIG) goto sighandler;
    q2_ith = retval_area[0];

    if  ((*(op_list[0]))(q1_ith, q2_ith) == SIG) goto sighandler;
    
    if (retval_area[0] == FALSE) {
      return RET;
    }
  }
  
  /* return(true) */
  retval_area[0] = TRUE;
  return RET;
  
  /* exception handler */
 sighandler:
  out_handler();
  return SIG;
}

/* copy = proc(sequence[T])returns(sequence[T])
 *        where T has copy:proctype(T)returns(T) */

int sequence_copy(int (*(op_list[]))(), sequence x)
{
  int i;			/* loop control */
  sequence y;
  int x_size;
  elt x_ith;
  
  /* y := sequence[T]$new() */
  if (sequence_new() == SIG) goto sighandler;
  y = (sequence) retval_area[0];
  
  /* for i: int in x!indexes() do ... */
  if (sequence_size(x) == SIG) goto sighandler;
  x_size = retval_area[0];
  
  for (i = 1; i <= x_size; i++) {

    /* y := sequence[T]$addh(y, T$copy(x[i]) */
    if (sequence_fetch(x, i) == SIG) goto sighandler;
    x_ith = retval_area[0];
    
    if ((*(op_list[0]))(x_ith) == SIG) goto sighandler;
    
    if (sequence_addh(y, retval_area[0]) == SIG) goto sighandler;
    y = (sequence) retval_area[0];
  }
  
  /* return(y) */
  retval_area[0] = (elt) y;
  return RET;
  
  /* exception handler */
 sighandler:
  out_handler();
  return SIG;
}

/*  encode = proc(q: sequence[T], s: istream) signals(not_possible(string))
 *		where T has encode: proctype(T, istream)
 *				    signals(not_possible(stirng))
 *	modifies  s.
 *	effects  Writes an encoding of q onto the istream s.	 */

int sequence_encode(int (*(op_list[]))(), sequence q, istream s)
{
  int size;
  int i;
  elt *buf;
  int id;
  
  /* check if this sequence has been already encoded */
  
  istream_check_history(s, q);
  id = (int) retval_area[0];
  if (istream_puti(s, id) == SIG) {
    return(SIG);
  }
  if (id != NOT_YET) {
    return(RET);
  }
  
  /* encode sequence */
  size = q->size;
  if (istream_puti(s, size) == SIG) {
    return(SIG);
  }
  buf = q->buf;
  for (i = 0; i < size; i++) {
    if ((*(op_list[0]))(buf[i], s) == SIG)
      return(SIG);
  }
  return(RET);
}

/*  decode = proc(s: istream) returns(sequence[T])
 *			      signals(end_of_file, not_possible(string))
 *		where T has decode: proctype(istream) returns(T)
 *				    signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.		 */

int sequence_decode(int (*(op_list[]))(), istream s)
{
  int sz;
  int i;
  sequence q;
  elt *buf;
  int id;
  
  /* check if this sequence has been already decoded */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  id = (int) retval_area[0];
  if (id != NOT_YET) {
    int res;
    res = istream_get_obj(s, id);
    if (res == SIG && strcmp(signame, "bounds") == 0) {
      /* this can't happen... */
      signame = "not_possible";
      sigarg_area[0] = (elt) "wrong id";
    }
    return(res);
  }
  
  /* get size, and check it */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  sz = (int) retval_area[0];
  
  if (sz < 0) {
    sigarg_area[0] = (elt) "bad format";
    signame = "not_possible";
    return(SIG);
  }
  
  /* create sequence object, and add it to history */
  q = (sequence) malloc(sizeof(struct sequence_rep));
  q->size = sz;
  q->buf = NULL;
  istream_add_history(s, q);
  
  /* get elements */
  if (sz == 0) {
    retval_area[0] = (elt) q;
    return(RET);
  }
  
  buf = (elt *) malloc(sz * sizeof(elt));
  q->buf = buf;
  for (i = 0; i < sz; i++) {
    if ((*(op_list[0]))(s) == SIG)
      return(SIG);

    buf[i] = (elt) retval_area[0];
  }
  retval_area[0] = (elt) q;
  return(RET);
}

/* similar = proc(record[N1:T1,...,Nn:Tn],record([N1:T1,...,Nn:Tn])
		   returns(bool)
		   where each Ti has similar:proctype(Ti,Ti)returns(bool) */

int record_similar(int (*(op_list[]))(), record r1, record r2)
{
  return(record_similar_body(op_list, r1, r2));
}

/* similar1 = proc(record[N1:T1,...,Nn:Tn],record([N1:T1,...,Nn:Tn])
		    returns(bool)
		    where each Ti has equal:proctype(Ti,Ti)returns(bool) */

int record_similar1(int (*(op_list[]))(), record r1, record r2)
{
  return(record_similar_body(op_list, r1, r2));
}

int record_similar_body(int (*(op_list[]))(), record r1, record r2)
{
  int (* op)();
  int i = 0, j, rec_sz;

  rec_sz = r1[0] - 1; 		/* get the number of record filelds */
  
  while (i < rec_sz) {
    op = op_list[i++];
    if ((*op)(r1[i], r2[i]) == SIG) {
      out_handler();    /* exception handling  */
      return(SIG);
    }
    if (retval_area[0] == FALSE)
      return(RET);
  }
  retval_area[0] = (elt) TRUE;
  return(RET);
}

/* copy = proc(record[N1:T1,...,Nn:Tn])returns(record[N1:T1,...,Nn:Tn])
 *        where each Ti has copy:proctype(Ti)returns(bool)		*/

int record_copy(int (*(op_list[]))(), record r1)
{
  int i, rec_size;
  record res;
  
  /* create new object */
  rec_size = r1[0];
  res = (record) malloc(rec_size*sizeof(elt));
  res[0] = rec_size;

  /* put the return value of t$copy to each slot */
  for (i = 1; i <= rec_size -1 ; i++) {
    /* calling t$copy */
    if ((*(op_list[i-1]))(r1[i]) == SIG){
      out_handler();
      return(SIG);
    }
    res[i] = retval_area[0];
  }
  retval_area[0] = (elt) res;
  return(RET);
}

/*  encode = proc(r: rt, s: istream) signals(not_possible(string))
 *		where each Ti has encode: proctype(Ti, istream)
 *				    signals(not_possible(stirng))
 *	modifies  s.
 *	effects  Writes an encoding of r onto the istream s.
 *
 *	( rt = record[N1: T1, ..., Nn: Tn] )			 */

int record_encode(int (*(op_list[]))(), record r, istream s)
{
  int ncom;				/* number of components */
  int i;				/* loop counter */
  int id;
  
  /* check if this record has been already encoded */
  istream_check_history(s, r);
  id = (int) retval_area[0];
  if (istream_puti(s, id) == SIG) {
    return(SIG);
  }
  if (id != NOT_YET) {
    return(RET);
  }
  
  /* encode number of components */
  ncom = r[0] - 1;
  if (istream_puti(s, ncom) == SIG) {
    return(SIG);
  }
  
  /* encode each component */
  for (i = 1; i <= ncom; i++) {
    if ((*(op_list[i-1]))(r[i], s) == SIG)
      return(SIG);
  }
  return(RET);
}

/*  decode = proc(s: istream) returns(rt)
 *			      signals(end_of_file, not_possible(string))
 *		where each Ti has decode: proctype(istream) returns(Ti)
 *				    signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 *
 *	( rt = record[N1: T1, ..., Nn: Tn] )				 */

int record_decode(int (*(op_list[]))(), istream s)
{
  int ncom;				/* number of components */
  record r;
  int i;				/* loop counter */
  int id;
  
  /* check if this record has been already decoded */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  id = (int) retval_area[0];
  if (id != NOT_YET) {
    int res;
    res = istream_get_obj(s, id);
    if (res == SIG && strcmp(signame, "bounds") == 0) {
      /* this can't happen... */
      signame = "not_possible";
      sigarg_area[0] = (elt) "wrong id";
    }
    return(res);
  }
  
  /* get number of component */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  ncom = (int) retval_area[0];
  
  if (ncom <= 0) {
    signame = "not_possible";
    sigarg_area[0] = (elt) "bad format";
    return(SIG);
  }
  
  /* create record object, and add it to history */
  r = (record) malloc((ncom + 1) * sizeof(elt));
  r[0] = ncom + 1;
  istream_add_history(s, r);
  
  /* decode each component */
  for (i = 1; i <= ncom; i++) {
    if ((*(op_list[i-1]))(s) ==SIG)
      return(SIG);
    r[i] = (elt) retval_area[0];
  }
  retval_area[0] = (elt) r;
  return(RET);
}

/* equal = proc(struct[N1:T1,...,Nn:Tn],struct[N1:T1,...,Nn:Tn])returns(bool)
 *           where each Ti has equal:proctype(Ti,Ti)returns(bool)	 */

int struct_equal(int (*(op_list[]))(), struct_ r1, struct_ r2)
{
  return(struct_equal_body(op_list, r1, r2));
}

/* similar = proc(struct[N1:T1,...,Nn:Tn],struct[N1:T1,...,Nn:Tn])returns(bool)
 *           where each Ti has similar:proctype(Ti,Ti)returns(bool)	 */

int struct_similar(int (*(op_list[]))(), struct_ r1, struct_ r2)
{
  return(struct_equal_body(op_list, r1, r2));
}

int struct_equal_body(int (*(op_list[]))(), struct_ r1, struct_ r2)
{
  int i, com_sz;

  com_sz = r1[0] - 1;
  
  for (i = 1; i <= com_sz; i++) {
    /* calling t$equal */
    if ((*(op_list[i-1]))(r1[i], r2[i]) == SIG) {
      /* exception handling  */
      out_handler();
      return(SIG);
    }
    if (retval_area[0] == FALSE)
      return(RET);
  }
  retval_area[0] = (elt) TRUE;
  return(RET);
}

/* copy = proc(struct[N1:T1,...,Nn:Tn])returns(struct[N1:T1,...,Nn:Tn])
 *        where each Ti has copy:proctype(Ti)returns(bool)		 */

int struct_copy(int (*(op_list[]))(), struct_ s1)
{
  int i, obj_sz;
  struct_ res;
  
  /* create new object */
  obj_sz = s1[0];
  res = (struct_) malloc(obj_sz*sizeof(elt));
  res[0] = obj_sz;
  
  /* put the return value of t$copy to each slot */
  for (i = 1; i <= obj_sz -1 ; i++) {
    /* calling t$copy */
    if ((*(op_list[i-1]))(s1[i]) == SIG) {
      /* exception handling  */
      out_handler();
      return(SIG);
    }
    res[i] = retval_area[0];
  }
  retval_area[0] = (elt) res;
  return(RET);
}

/*  encode = proc(r: st, s: istream) signals(not_possible(string))
 *		where each Ti has encode: proctype(Ti, istream)
 *				    signals(not_possible(stirng))
 *	modifies  s.
 *	effects  Writes an encoding of r onto the istream s.
 *
 *	( st = struct[N1: T1, ..., Nn: Tn] )		 */

int struct_encode(int (*(op_list[]))(), struct_ r, istream s)
{
  int ncom;				/* number of components */
  int i;				/* loop counter */
  int id;
  
  /* check if this struct has been already encoded */
  istream_check_history(s, r);
  id = (int) retval_area[0];
  if (istream_puti(s, id) == SIG) {
    return(SIG);
  }
  if (id != NOT_YET) {
    return(RET);
  }
  
  /* encode number of components */
  ncom = r[0] - 1;
  if (istream_puti(s, ncom) == SIG) {
    return(SIG);
  }
  
  /* encode each component */
  for (i = 1; i <= ncom; i++) {
    if ((*(op_list[i-1]))(r[i], s) == SIG)
      return(SIG);
  }
  return(RET);
}

/*  decode = proc(s: istream) returns(st)
 *			      signals(end_of_file, not_possible(string))
 *		where each Ti has decode: proctype(istream) returns(Ti)
 *				    signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 *
 *	( st = struct[N1: T1, ..., Nn: Tn] )			        */

int struct_decode(int (*(op_list[]))(), istream s)
{
  int ncom;				/* number of components */
  struct_ r;
  int i;				/* loop counter */
  int id;
  
  /* check if this struct has been already decoded */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  id = (int) retval_area[0];
  if (id != NOT_YET) {
    int res;
    res = istream_get_obj(s, id);
    if (res == SIG && strcmp(signame, "bounds") == 0) {
      /* this can't happen... */
      signame = "not_possible";
      sigarg_area[0] = (elt) "wrong id";
    }
    return(res);
  }
  
  /* get number of component */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  ncom = (int) retval_area[0];
  
  if (ncom <= 0) {
    signame = "not_possible";
    sigarg_area[0] = (elt) "bad format";
    return(SIG);
  }
  
  /* create struct object, and add it to history */
  r = (struct_) malloc((ncom + 1) * sizeof(elt));
  r[0] = ncom + 1;
  istream_add_history(s, r);
  
  /* decode each component */
  for (i = 1; i <= ncom; i++) {
    if ((*(op_list[i-1]))(s) == SIG)
      return(SIG);
    r[i] = (elt) retval_area[0];
  }
  retval_area[0] = (elt) r;
  return(RET);
}

/* similar = proc(v1, v2: variant[N1:T1, ..., Nn:Tn]) returns(bool)
 *	where each Ti has similar: proctype(Ti, Ti) returns(bool)	 */

int variant_similar(int (*(op_list[]))(), variant v1, variant v2)
{
  return(variant_similar_body(op_list, v1, v2));
}

/* similar1 = proc(v1, v2: variant[N1: T1, ..., Nn: Tn]) returns(bool)
 *	where each Ti has equal: proctype(Ti, Ti) returns(bool) */

int variant_similar1(int (*(op_list[]))(), variant v1, variant v2)
{
  if (variant_similar_body(op_list, v1, v2) == SIG)
    return(SIG);
  return(RET);
}

int variant_similar_body(int (*(op_list[]))(), variant v1, variant v2)
{
  /* check tag */
  if (v1->tag != v2->tag) {
    retval_area[0] = (elt) FALSE;
    return RET;
  }
  
  /* check similarity of the two variants */
  if ((*(op_list[v1->tag - 1]))(v1->value, v2->value) == SIG) {
    /* exception handler */
    out_handler();
    return(SIG);
  }
  return (RET);
}

/* copy = proc(v: variant[N1:T1, ..., Nn:Tn])
 *	returns(variant[N1:T1, ..., Nn:Tn])
 *	where each Ti has copy: proctype(Ti) returns(Ti)	 */

int variant_copy(int (*(op_list[]))(), variant r1)
{
  int i, nr_sel;
  variant newobj;

  /* calling t$copy */
  if ((*(op_list[r1->tag - 1]))(r1->value) == SIG) {
    /* exception handling  */
    out_handler();
    return(SIG);
  }
  
  /* create new object */
  newobj = (variant) malloc(sizeof(struct variant_rep));
  newobj->tag = r1->tag;
  newobj->value = retval_area[0];
  retval_area[0] = (elt) newobj;
  return(RET);
}

/*  encode = prvc(v: vt, s: istream) signals(not_possible(string))
 *		where each Ti has encode: proctype(Ti, istream)
 *				    signals(not_possible(stirng))
 *	modifies  s.
 *	effects  Writes an encoding of v onto the istream s.
 *
 *	( vt = variant[N1: T1, ..., Nn: Tn] )			 */

int variant_encode(int (*(op_list[]))(), variant v, istream s)
{
  int tag;
  int id;
  
  /* check if this variant has been already encoded */
  istream_check_history(s, v);
  id = (int) retval_area[0];
  if (istream_puti(s, id) == SIG) {
    return(SIG);
  }
  if (id != NOT_YET) {
    return(RET);
  }
  
  /* encode tag */
  tag = v->tag;
  if (istream_puti(s, tag) == SIG) {
    return(SIG);
  }
  
  /* encode value (calling t$encode) */
  if ((*(op_list[tag-1]))(v->value, s) == SIG)
    return(SIG);

  return(RET);
}

/*  decode = proc(s: istream) returns(vt)
 *			      signals(end_of_file, not_possible(string))
 *		where each Ti has decode: proctype(istream) returns(Ti)
 *				    signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 *
 *	( vt = variant[N1: T1, ..., Nn: Tn] )				 */

int variant_decode(int (*(op_list[]))(), istream s)
{
  int tag;
  variant v;
  int id;
  
  /* check if this variant has been already decoded */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  id = (int) retval_area[0];
  if (id != NOT_YET) {
    int res;
    res = istream_get_obj(s, id);
    if (res == SIG && strcmp(signame, "bounds") == 0) {
      /* this can't happen... */
      signame = "not_possible";
      sigarg_area[0] = (elt) "wrong id";
    }
    return(res);
  }
  
  /* get tag */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  tag = (int) retval_area[0];
  if (tag < 1) {
    signame = "not_possible";
    sigarg_area[0] = (elt) "bad format";
    return(SIG);
  }
  
  /* create variant object, and add it to history */
  v = (variant) malloc(sizeof(struct variant_rep));
  v->tag = tag;
  istream_add_history(s, v);
  
  /* get value */
  if ((*(op_list[tag-1]))(s) == SIG) 
    return(SIG);
  
  /* return new obj */
  v->value = retval_area[0];
  retval_area[0] = (elt) v;
  return(RET);
}

/* equal = proc(o1, o2:oneof[N1:T1, ..., Nn:Tn]) returns(bool)
 *	   where each Ti has equal: proctype(Ti, Ti) returns(bool)	 */

int oneof_equal(int (*(op_list[]))(), oneof o1, oneof o2)
{
  return(oneof_equal_body(op_list, o1, o2));
}


/* similar = proc(o1, o2:oneof[N1:T1, ..., Nn:Tn]) returns(bool)
 *	     where each Ti has similar: proctype(Ti, Ti) returns(bool)	 */

int oneof_similar(int (*(op_list[]))(), oneof o1, oneof o2)
{
  return(oneof_equal_body(op_list, o1, o2));
}

int oneof_equal_body(int (*(op_list[]))(), oneof o1, oneof o2)
{
  /* compare tag parts
   * if (o1->tag != o2->tag) return(false); */
  if (o1->tag != o2->tag) {
    retval_area[0] = FALSE;
    return(RET);
  }
  
  /* compare value parts.
   * if o1->value !equal o2->value return(false); */
  if ((*(op_list[o1->tag - 1]))(o1->value, o2->value) == SIG) {
    out_handler();
    return(SIG);
  }
  return(RET);
}

/* copy = proc(o:oneof[N1:T1, ..., Nn:Tn]) returns(oneof[N1:T1, ..., Nn:Tn]))
 *        where each Ti has copy: proctype(Ti) returns(Ti)		 */

int oneof_copy(int (*(op_list[]))(), oneof src)
{
  oneof dst;
  
  /* dst = oneof[N1:T1, ..., Nn:Tn]$copy(src) */
  if ((*(op_list[src->tag - 1]))(src->value) == SIG) {
    /* exception handler */
    out_handler();
    return(SIG);
  }

  /* make new obj */
  dst = (oneof)malloc(sizeof(struct oneof_rep));
  dst->value = (elt)retval_area[0];
  dst->tag = src->tag;
  
  retval_area[0] = (elt)dst;
  return(RET);
}

/*  encode = proc(o: ot, s: istream) signals(not_possible(string))
 *		where each Ti has encode: proctype(Ti, istream)
 *				    signals(not_possible(stirng))
 *	modifies  s.
 *	effects  Writes an encoding of o onto the istream s.
 *
 *	( ot = oneof[N1: T1, ..., Nn: Tn] )			 */

int oneof_encode(int (*(op_list[]))(), oneof o, istream s)
{
  int tag;
  int id;
  
  /* check if this oneof has been already encoded */
  istream_check_history(s, o);
  id = (int) retval_area[0];
  if (istream_puti(s, id) == SIG) {
    return(SIG);
  }
  if (id != NOT_YET) {
    return(RET);
  }
  
  /* encode tag */
  tag = o->tag;
  if (istream_puti(s, tag) == SIG) {
    return(SIG);
  }
  
  /* calling t$encode */
  return((*(op_list[tag-1]))(o->value, s));
}

/*  decode = proc(s: istream) returns(ot)
 *			      signals(end_of_file, not_possible(string))
 *		where each Ti has decode: proctype(istream) returns(Ti)
 *				    signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 *
 *	( ot = oneof[N1: T1, ..., Nn: Tn] )				 */

int oneof_decode(int (*(op_list[]))(), istream s)
{
  int tag;
  oneof o;
  int id;
  
  /* check if this array has been already decoded */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  id = (int) retval_area[0];
  if (id != NOT_YET) {
    int res;
    res = istream_get_obj(s, id);
    if (res == SIG && strcmp(signame, "bounds") == 0) {
      /* this can't happen... */
      signame = "not_possible";
      sigarg_area[0] = (elt) "wrong id";
    }
    return(res);
  }
  
  /* get tag */
  if (istream_geti(s) == SIG) {
    return(SIG);
  }
  tag = (int) retval_area[0];
  if (tag < 1) {
    signame = "not_possible";
    sigarg_area[0] = (elt) "bad format";
    return(SIG);
  }
  
  /* create oneof object, and add it to history */
  o = (oneof) malloc(sizeof(struct oneof_rep));
  o->tag = tag;
  istream_add_history(s, o);
  
  /* get value */
  if ((*(op_list[tag-1]))(s) == SIG)
    return(SIG);

  /* return obj */
  o->value = retval_area[0];
  retval_area[0] = (elt) o;
  return(RET);
}
