/* 
 * $Id: file_name.c,v 2.0 1992/09/23 08:40:43 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* not fully implemented */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <string.h>
#include "sys/param.h"

/*
 * file_name = cluster is	create, parse, unparse, get_dir, get_name,
 *				get_suffix, get_other, make_output, make_temp,
 *				print, equal, similar, copy, encode, decode,
 *				_gcd
 */

/*
 *	Because an object being allocated doesn't contain any pointer,
 *	malloc_atomic is used rather than malloc, expecting better efficiency.
 */

/*
 * create = proc (dir, name, suffix, other: string) returns (file_name)
 *          signals (bad_format) 
 */

file_name_create(string dir,string name,string suffix,string other)
{
  char res[200], i, dirlen;
  char* s;
  if ((index(name, '/') > 0) || (index(suffix, '/') > 0)){
    signame = "bad_format";
    return(SIG);
  }
/*
 * Code below are from Liskov's, but I ignore this.
 * We want to use '.' in name field.
 *		kihara
 *
 * i = index(name, '.');
 * if (i > 0)
 *   for(i++; i < strlen(name); i++)
 *     if (name[i] != '.') {
 *	signame = "bad_format";
 *	return(SIG);
 *     }
 * i = index(suffix, '.');
 * if (i > 0) {
 *   if (i == 1) {
 *     signame = "bad_format";
 *     return(SIG);
 *   }
 *   for(i++; i < strlen(name); i++)
 *     if (name[i] != '.') {
 *	signame = "bad_format";
 *	return(SIG);
 *     }
 * if (other != NULL)
 *   if (other[0] == '.'){
 *     signame = "bad_format";
 *     return(SIG);
 *   }
 */
  if (index(suffix, '.')) {
	signame = "bad_format";
	return(SIG);
  }
  if (other != NULL)
    if (other[0] != '\0') {
	signame = "bad_format";
	return(SIG);
  }

  strcpy(res,dir);
  dirlen = strlen(dir);
  if (dirlen != 0) 
    if (dir[dirlen - 1] != '/')
      strcat(res, "/");
  strcat(res,name);
  if (suffix != NULL)
    if (suffix[0] != '\0') {
      strcat(res,".");
      strcat(res,suffix);
    }
  s = (char*)malloc_atomic(sizeof(char)*(strlen(res)+1));
  strcpy(s,res);
  retval_area[0] = (elt)s;
  return(RET);
}

/*
 * parse = proc(string)returns(file_name)
 */
 
int file_name_parse(string s)
{
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * unparse = proc(file_name)returns(string)
 */

int file_name_unparse(file_name fname)
{
  retval_area[0] = (elt) fname;
  return(RET);
}

/*
 * get_dir = proc(file_name)returns(string)
 */

file_name_get_dir(file_name fname)
{
  char* s;
  char str[200];
  int len;
  int i, j, c;

  len = strlen(fname);
  if(len == 0)
  {
    /* if null, return null.. */
    s = (char *)malloc_atomic(sizeof(char));
    s[0] = '\0';
  } else {
    c = 0;
    for (j = 0; j < len; j++)
      if (fname[j] == '/') {
	c++;
	i = j;
      }
    /* last char must not be '/' if it is not all. */
    if (c == 0) {
      s = (char*) malloc_atomic(sizeof(char) * 2);
      s[0] = '\0';

    } else if ((c == 1) && (i == 0)) {
      s = (char*) malloc_atomic(sizeof(char) * 2);
      s[0] = '/';
      s[1] = '\0';
    } else {
      s = (char*)malloc_atomic(sizeof(char)*(i+1));
      strncpy(s,fname,i);
      s[i] = 0;
    }
  }
  retval_area[0] = (elt) s;
  return(RET);
}
 
/*
 * get_name = proc(file_name)returns(string)
 */

file_name_get_name(file_name fname)
{
  char* s;
  int len;
  int i,j;
  len = strlen(fname);
  if(len == 0)
  {
    s = (char*)malloc_atomic(sizeof(char));
    s[0] = 0;
  }
  else
  {
    for(i = len - 1;i >= 0 && fname[i] !=  '/'; i--) ;
    for(j = len - 1;j >= i && fname[j] !=  '.'; j--) ;
    if (i > j) j = len;		/* '.' is not found */
    if (j == len - 1) j = len;	/* '.' is last char for file name. */
    s = (char*)malloc_atomic(sizeof(char)*(j-i));
    strncpy(s,fname+i+1,j-i-1);
    s[j-i-1] = 0;
  }
  retval_area[0] = (elt) s;
  return(RET);
}
 
/*
 * get_suffix = proc(file_name)returns(string)
 */

file_name_get_suffix(file_name fname)
{
  char* s;
  int len;
  int i, j;
  len = strlen(fname);
  if(len == 0)
  {
    s = (char*)malloc_atomic(sizeof(char));
    s[0] = 0;
  }
  else
  {
    for(i = len - 1; i >= 0 && fname[i] != '/'; i--);
    for(j = len - 1; j >= i && fname[j] != '.'; j--);
    if (i > j) j = len - 1;	  /* '.' is not found */
    if (j == len - 1) j = len - 1; /* '.' is last char for file name. */
    s = (char*)malloc_atomic(sizeof(char)*(len-j));
    strncpy(s,fname+j+1,len-j-1);
    s[len-j-1] = 0;
  }
  retval_area[0] = (elt) s;
  return(RET);
}
 
/*
 * get_other = proc(file_name)returns(string)
 */

file_name_get_other(file_name fname)
{
  char* s = (char*)malloc_atomic(sizeof(char));
  s[0] = 0;
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * make_output = proc(file_name,string)returns(file_name)signals(bad_format)
 */
int file_name_make_output(file_name fname,string suffix)
{
  char* s;
  int len, slen, nlen;
  int i, j;

  if ((index(suffix, '.') > 0) || (index(suffix, '/') > 0)){
    signame = "bad_format";
    return(SIG);
  }

  len = strlen(fname);
  slen = strlen(suffix);

  if(len == 0)
  {
    /* fname is null */
    nlen = (slen != 0) ? 8 : 7;		/* "output" + '.' + '\0' */
    s = (char *) malloc_atomic(sizeof(char) * (nlen + slen));
    strcpy(s, "output");
    if (slen != 0) {
      strcat(s, ".");
      strcat(s, suffix);
    }
    s[slen + nlen - 1] = '\0';
  } else {
    for(i = len - 1; i >= 0 && fname[i] != '/'; i--);
    for(j = len - 1; j >= i && fname[j] != '.'; j--);
    if (i > j) j = len;		/* '.' is not found */
    if (j == len - 1) j = len;	/* '.' is last char of file name. */
    if (i == len - 1) {
      /* name, suffix part is null */
      nlen = (slen != 0) ? 8 : 7;
      s = (char *) malloc_atomic(sizeof(char) * (len + slen + nlen));
      strcpy(s, fname);
      strcat(s, "output");
      if (slen != 0) {
	strcat(s, ".");
        strcat(s, suffix);
      }
      s[len + slen + nlen - 1] = '\0';
    } else {
      /* suffix is not null */
      if (j == i + 1) {
        /* name part is null */
        nlen = (slen != 0) ? 8 : 7;
        s = (char *) malloc_atomic(sizeof(char) * (j + slen + nlen));
        strncpy(s, fname, j);
        strcat(s, "output");
      } else {
        /* name is not null */
        nlen = (slen != 0) ? 2 : 1;
        s = (char*) malloc_atomic(sizeof(char) * (j + slen + nlen));
        strncpy(s, fname, j);
      }
      if (slen != 0) {
	strcat(s, ".");
        strcat(s, suffix);
      }
      s[j + slen + nlen - 1] = 0;
    }
  }
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * make_temp = proc(tdir, prog, kind: string) returns(fname)
 *					      signals(bad_format)
 */

/* stub version */

int file_name_make_temp(string tdir, string prog, string kind)
{
    signame = "failure";
    sigarg_area[0] = (elt) "file_name$make_temp: not implemented";
    return SIG;
}

/*
 * print = proc (x: file_name, ps: pstream)
 */

int file_name_print(file_name x, clus ps)
{
    if ( _cpstream_text(ps, (string) x) == SIG ) {
	out_handler();
	return SIG;
    }
    return RET;
}

/*
 * equal = proc(fn1, fn2: file_name) returns(bool)
 *
 */

int file_name_equal(file_name fname1, file_name fname2)
{
    if (strcmp((char *) fname1, (char *) fname2) == 0) {
	retval_area[0] = (elt) TRUE;
    } else {
	retval_area[0] = (elt) FALSE;
    }
    return(RET);
}

/*
 * similar = proc(fn1, fn2: file_name) returns(bool)
 *
 */

int file_name_similar(file_name fname1, file_name fname2)
{
    if (strcmp((char *) fname1, (char *) fname2) == 0) {
	retval_area[0] = (elt) TRUE;
    } else {
	retval_area[0] = (elt) FALSE;
    }
    return(RET);
}

/*
 * copy = proc(x: file_name) returns(file_name)
 */

int file_name_copy(file_name x)
{
    retval_area[0] = (elt) x;
    return RET;
}

/*
 *  encode = proc(fn: file_name, s: istream) signals(not_possible(string))
 *	modifies  s.
 *	effects  Writes an encoding of fn onto the istream s.
 */

int file_name_encode(file_name fn, istream s)
{
    return(string_encode((string) fn, s));
}

/*
 *  decode = proc(s: istream) returns(file_name)
 *			      signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 */

int file_name_decode(istream s)
{
    return(string_decode(s));
}

/*
 * _gcd = proc(x: file_name, tab: gcd_tab) returns(int)
 */

/* stub version */

int file_name__gcd(file_name x, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "file_name$_gcd: not implemented";
    return SIG;
}
