/*
 * $Id: now.c,v 2.0 1992/09/23 08:42:32 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* now = proc() returns(date)
 *         % Returns the current date and time.
 *         end now    
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <sys/time.h> 

int _pnow()
{
    int except_level;
    long clock;
    struct tm *time;
    struct timeval tv;

    /*
     * begin body
     */ 
    
    except_level = 0;

    gettimeofday(&tv, (struct timezone *) 0);
    clock = tv.tv_sec;
    time = localtime(&clock);
    if (_cdate_create(time->tm_mday,
		      time->tm_mon + 1,
		      time->tm_year + 1900,
		      time->tm_hour,
		      time->tm_min,
		      time->tm_sec) == 0)
	goto sighandler;

    /*	Here we have the result date object in retval_area[0], so we do not
	have to set return value into retval_area[0]. */

    return RET;

    /*
     *	end body
     */

    /*
     *	signal handler (exception hadler)
     */

 sighandler:
    switch (except_level) {
    case -1:
	string_concat("unhandle exception: ", signame);
	sigarg_area[0] = retval_area[0];
	signame = "failure";
	return (SIG);
    case 0:
	if (!strcmp(signame, "failure"))
	    return (SIG);
	else {
	    string_concat("unhandle exception: ", signame);
	    sigarg_area[0] = retval_area[0];
	    signame = "failure";
	    return (SIG);
	}
    }
}
