/* 
 * $Id: real.c,v 2.0 1992/09/23 08:43:55 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <ctype.h>
#include<stdio.h>
#include<math.h>
#include<string.h>

#define MAX_NUM_LEN 30

/*
 * NOTE
 *
 * The overflow and underflow exceptions does not raised.
 * The f2i and i2f macros cannot be nested, and more than one of these
 * macros cannot be used in one expression or in one argument list.
 *
 */

/*
 * add = proc(real,real)returns(real)signals(overflow)
 */

int real_add(int x, int y)
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  retval_area[0] = f2i(x1 + y1);
  return(RET);
}

/*
 * sub = proc(real,real)returns(real)signals(overflow)
 */

int real_sub(int x, int y)
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  retval_area[0] = f2i(x1 - y1);
  return(RET);
}

/*
 * mul = proc(real,real)returns(real)signals(overflow)
 */

int real_mul(int x, int y)
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  retval_area[0] = f2i(x1 * y1);
  return(RET);
}

/*
 * minus = proc(real)returns(real)signals(overflow,underflow)
 */

int real_minus(int x)
{
  float fx = i2f(x);
  retval_area[0] = f2i(-fx);
  return(RET);
}

/*
 * div = proc(real,real)returns(real)signals(overflow)
 */

int real_div(int x, int y)
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  if(y1 == 0)
  {
    signame = "zero_divide";
    return(SIG);
  }
  retval_area[0] = f2i(x1 / y1);
  return(RET);
}

/*
 * power = proc(real,real)returns(real)
 *         signals(zero_divide,complex_result,overflow,underflow)
 */

int real_power(int x, int y)		/* overfolw & underflow is ignore */
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  
  if(y1 == 0)
  {
    retval_area[0] = (elt)f2i((float)1);
  }
  else if(x1 == 0)
  {
    if(y1 < 0)
    {
      signame = "zero_divide";
      return(SIG);
    }
    else retval_area[0] = (elt)0;
  }
  else if(x1 < 0)
  {
    int v;
    if(y1 != (v = (int)y1))
    {
      signame = "complex_result";
      return(SIG);
    }
    else
    {
      float vv = pow(fabs(x1),y1);
      retval_area[0] = (elt)f2i((((v/2)*2 == v) ? vv : -(vv)));
    }
  }
  else retval_area[0] = (elt)f2i(pow((double)x1,(double)y1));
  return(RET);
}
  
/*
 * abs = proc(real)returns(real)signals(overflow)
 */

int real_abs(int x)
{
  float x1 = i2f(x);
  retval_area[0] = (elt)f2i((x1 >= 0) ? x1 : -x1);
  return(RET);
}

/*
 * max = proc(real,real)returns(real)
 */

int real_max(int x, int y)
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  retval_area[0] = (elt)f2i((x1 >= y1) ? x1 : y1);
  return(RET);
}

/*
 * min = proc(real,real)returns(real)
 */

int real_min(int x, int y)
{
  float x1 = i2f(x);
  float y1 = i2f(y);
  retval_area[0] = (elt)f2i((x1 <= y1) ? x1 : y1);
  return(RET);
}

/*
 * i2r = proc(int)returns(real)signals(overflow)
 */

int real_i2r(int x)
{
  retval_area[0] = (elt)f2i((real)x);
  return(RET);
}

/*
 * r2i = proc(real)returns(int)signals(overflow)
 */

int real_r2i(int x)
{
  retval_area[0] = (elt)(int)i2f(x);
  return(RET);
}

/*
 * trunc = proc(real)returns(int)signals(overflow)
 */

int real_trunc(int x)
{
  retval_area[0] = (elt)(int)i2f(x);
  return(RET);
}

/*
 * exponent = proc(real)returns(int)signals(overflow)
 */

int real_exponent(int x)
{
  float x1 = fabs(i2f(x));
  if(x1 == 0)
  {
    signame = "undefined";
    return(SIG);
  }
  retval_area[0] = (x1>=0) ? floor(log10(x1)) : ceil(log10(x1));
  return(RET);
}

/*
 * mantissa = proc(real)returns(real)
 */

int real_mantissa(int x)
{
  float x1 = i2f(x);
  char* s;
  int i;
  if(x1 == 0)
  {
    retval_area[0] = (elt)(float)0.0;
    return(RET);
  }
  real_unparse(x);
  s = (char*)retval_area[0];
  for(i=strlen(s)-1;isdigit(s[i]);i--) s[i]='0';
  real_parse((char*)retval_area[0]);
  return(RET);
}

/*
 * parse = proc(string)returns(real)signals(bad_format,overflow)
 */

int real_parse(string s)		/* overflow is ignored */
{
/*
  char *charp;
  float v = strtod(s, &charp);

  if (*charp != '\0') {
    signame = "bad_format";
    return(SIG);
  }
  retval_area[0] = (elt)f2i(v);
  return(RET);
*/
  int p = 0;              /* $B>.?tE@0J2<$N7e?t(B */
  int v = 0;              /* $B2>?tIt!J>.?tE@$rL5;k!K(B */
  int w = 0;              /* $B;X?tIt(B */
  float val;              /* $B<B:]$KJV$9CM(B */
  float exp;
  char* ptr = (char*)s;
  char* tmp;
  int man_sgn = 0;        /* $B2>?tIt$NId9f(B */
  int exp_sgn = 0;        /* $B;X?tIt$NId9f(B */
  if(*ptr == '-')
  {
    man_sgn = 1;
    ptr++;
  }
  tmp = ptr;
  while(isdigit(*ptr))
  {
    v = v * 10 + (*ptr - '0');
    ptr++;
  }
  if(*ptr == '.')
  {
    ptr++;
    while(isdigit(*ptr))
    {
      v = v * 10 + (*ptr -'0');
      p++;
      ptr++;
    }
  }
  if((tmp == ptr) ||
     ((tmp + 1 == ptr) && (*tmp == '.')))     /* $B2>?tIt$,6u(Bor$B>.?tE@$N$_(B */
  {
    signame = "bad_format";
    return(SIG);
  }
  if(*ptr == 'e' || *ptr == 'E')
  {
    ptr++;
    if(*ptr == '-')
    {
      ptr++;
      exp_sgn = 1;
    }
    else if(*ptr == '+') ptr++;
    tmp = ptr;
    while(isdigit(*ptr))
    {
      w = w * 10 + (*ptr -'0');
      ptr++;
    }
    if(tmp == ptr)                    /* $B;X?tIt$,6u(B */
    {
      signame = "bad_format";
      return(SIG);
    }
  }
  if(*ptr != '\0')
  {
    signame = "bad_format";
    return(SIG);
  }
  exp = pow((double)10,(double)(((exp_sgn) ? (-w) : w) - p));
  val = ((float)((man_sgn) ? (-v) : v)) * exp;
  retval_area[0] = (elt)f2i(val);
  return(RET);
}

/*
 * unparse = proc(real)returns(string)
 */

int real_unparse(int x)
{
  char s[MAX_NUM_LEN];
  string res;
  int length;
  
  sprintf(s, "%e", i2f(x));
  length = strlen(s);
  /*
   *	Because an object being allocated doesn't contain any pointer,
   *	malloc_atomic is used rather than malloc, expecting better efficiency.
   */
  res = (string) malloc_atomic(length + 1);
  strcpy(res, s);
  retval_area[0] = (elt) res;
  return(RET);
}

/*
 * lt = proc(real,real)returns(bool)
 */

int real_lt(int x, int y)
{
  float fx = i2f(x);
  float fy = i2f(y);
  retval_area[0] = (elt) (fx < fy);
  return(RET);
}

/*
 * le = proc(real,real)returns(bool)
 */

int real_le(int x, int y)
{
  float fx = i2f(x);
  float fy = i2f(y);
  retval_area[0] = (elt) (fx <= fy);
  return(RET);
}

/*
 * ge = proc(real,real)returns(bool)
 */

int real_ge(int x, int y)
{
  float fx = i2f(x);
  float fy = i2f(y);
  retval_area[0] = (elt) (fx >= fy);
  return(RET);
}

/*
 * gt = proc(real,real)returns(bool)
 */

int real_gt(int x, int y)
{
  float fx = i2f(x);
  float fy = i2f(y);
  retval_area[0] = (elt) (fx > fy);
  return(RET);
}

/*
 * equal = proc(real,real)returns(bool)
 */

int real_equal(int x, int y)
{
  float fx = i2f(x);
  float fy = i2f(y);
  retval_area[0] = (elt) (fx == fy);
  return(RET);
}

/*
 * similar = proc(real,real)returns(bool)
 */

int real_similar(int x, int y)
{
  float fx = i2f(x);
  float fy = i2f(y);
  retval_area[0] = (elt) (fx == fy);
  return(RET);
}

/*
 * copy = proc(real,real)returns(bool)
 */

int real_copy(int i)
{
  retval_area[0] = (elt) i;
  return(RET);
}

/*
 * print = proc(r: real, pst: pstream)
 */

int real_print(real r, clus pst) 
{
    real_unparse(r);
    if ( _cpstream_text(pst, retval_area[0]) == SIG ) {
	out_handler();
	return(SIG);
    }
    return(RET);
}

/*
 *  encode = proc(r: real, s: istream) signals(not_possible(string))
 *	modifies  s.
 *	effects  Writes an encoding of r onto the istream s.
 */

int real_encode(real r, istream s)
{
    return(istream_puti(s, (int) r));
}

/*
 *  decode = proc(s: istream) returns(real)
 *			      signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 */

int real_decode(istream s)
{
    return(istream_geti(s));
}

/*
 *  This function does not correspond to CLU operation, used only
 *  internally in the system.
 */

int real_lit(double x)
{
    return f2i((float)(x));
}

/*
 * _gcd = proc(r: real, tab: gcd_tab) returns(int)
 */

int real__gcd(real r, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "real$_gcd: not implemented";
    return(SIG);
}
