/* 
 * $Id: struct.c,v 2.0 1992/09/23 08:45:43 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/*
 * get_Ni = proc(struct[N1:T1,...,Nn:Tn])returns(Ti)
 */

int struct_get(int i, struct_ s)
{
  retval_area[0] = s[i];
  return(RET);
}

/*
 * replace = proc(struct[N1:T1,...,Nn:Tn],Ti)returns(struct[N1:T1,...,Nn:Tn])
 */

int struct_replace(int i, struct_ s,elt e)
{
  int size = s[0]*sizeof(elt);
  struct_ newstr = (struct_)malloc(size);
  bcopy(s,newstr,size);
  newstr[i] = e;
  retval_area[0] = (elt)newstr;
  return(RET);
}

/*
 * s2r = proc(struct[N1:T1,...,Nn:Tn])returns(record[N1:T1,...,Nn:Tn])
 */

int struct_s2r(struct_ s)
{
  int size = s[0]*sizeof(elt);
  record newrec = (struct_)malloc(size);
  bcopy(s,newrec,size);
  retval_area[0] = (elt)newrec;
  return(RET);
}

/*
 * r2s = proc(record[N1:T1,...,Nn:Tn])returns(struct[N1:T1,...,Nn:Tn])
 */

int struct_r2s(record r)
{
  int size = r[0]*sizeof(elt);
  struct_ newstr = (struct_)malloc(size);
  bcopy(r,newstr,size);
  retval_area[0] = (elt)newstr;
  return(RET);
}

/*
 * print = proc(s: struct[n1: t1, ... nn: tn], pst: pstream)
 *	where each ti has print: proctype(ti, pstream)
 */

int struct_print(int (*(op_list[]))(), struct_ s, clus pst)
{
    int i;

    if ( _cpstream_start(pst, "{") == SIG ) {
	out_handler();
	return SIG;
    }
    for ( i = 1; i < s[0]; i++ ) {
	if ( i > 1 ) {
	    if ( _cpstream_pause(pst, ", ") == SIG ) {
		out_handler();
		return SIG;
	    }
	    bool_not((bool) retval_area[0]);
	    if ( (bool) retval_area[0] ) {
		break;
	    }
	}
	(*(op_list[i - 1]))(s[i], pst);	 	/* invoke ti$print */
    }
    if ( _cpstream_stop(pst, "}") == SIG ) {
	out_handler();
	return SIG;
    }
    return RET;
}

/*
 * _gcd = proc (s: struct[n1: t1, ... nn: tn], tab: gcd_tab) returns(int)
 *	where each ti has _gcd: proctype(it, gcd_tab) returns(int)
 */

int struct__gcd(int (*(op_list[]))(), struct_ s, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "struct$_gcd: not implemented";
    return SIG;
}
