/* 
 * $Id: wvec.c,v 2.0 1992/09/23 08:46:17 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* fully implemented ? */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

int _cwvec_create(int size)
{
  wvec w;

  w = (wvec) malloc(sizeof(struct wvec_rep));
  w->size = size;
  w->buf = (elt *) malloc(sizeof(elt)*size);
  retval_area[0] = (elt) w;
  return(RET);
}

int _cwvec_size(wvec w)
{
  retval_area[0] = w->size;
  return(RET);
}

int _cwvec_fetch(wvec w, int offset)      /* offset is long word size */
{
  if (offset < 1 || offset > w->size) {  /* check boundary */
    signame = "bounds";
    return(SIG);
  }
  retval_area[0] = w->buf[offset-1];
  return(RET);
}

int _cwvec_store(wvec w, int offset, int val) /* offset is long word size */
{
  if (offset < 1 || offset > w->size) {  /* check boundary */
    signame = "bounds";
    return(SIG);
  }
  w->buf[offset-1] = (elt) val;
  return(RET);
}

int _cwvec_wfetch(wvec w, int offset)      /* offset is byte size */
{
  char *top;
  unsigned short *wordp;

  if (offset < 1 || offset > w->size*sizeof(elt)) {  /* check boundary */
    signame = "bounds";
    return(SIG);
  }
  top = (char *) w->buf;
  wordp = (unsigned short *)(top + offset - 1);
  retval_area[0] = *wordp;
  return(RET);
}

int _cwvec_wstore(wvec w, int offset, int val)      /* offset is byte size */
{
  char *top;
  unsigned short *wordp;

  if (offset < 1 || offset > w->size*sizeof(elt)) {  /* check boundary */
    signame = "bounds";
    return(SIG);
  }
  top = (char *) w->buf;
  wordp = (unsigned short *)(top + offset -1);
  *wordp = (unsigned short) val;
  return(RET);
}

int _cwvec_move_lr(wvec w1, int s1, wvec w2, int s2, int len)
{
  int i;

  if (len < 1) {
    signame = "negative_size";
    return(RET);
  }
  if ( s1 < 1 || s2 < 1 || s1 > w1->size + len -1 || s2 > w2->size + len -1) {
    signame = "bounds";
    return(RET);
  }
  for(i = 0; i < len ; i++)
    w2->buf[s2+i-1] = w1->buf[s1+i-1];
  return(RET);
}
