/*
 * $Id: _all_dir_entries.c,v 2.0 1992/09/23 09:25:37 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/*
 * Low level support for _all_dir_entries_.
 * Return concatenated all file name in the directory.
 *
 * _all_dir_entries = proc(string) returns(string)
 *				   signals(not_possible(string))
 */


#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <sys/types.h>
#include <sys/dir.h>		/* <dirent.h> is preferred ... */
#include <stdio.h>
#include <errno.h>
#include <strings.h>

extern char* sys_errlist[];
char *malloc_atomic();

int _p_all_dir_entries(string dirname)
{
    char *list;
    DIR *dirp;
    struct direct *dp;
    long start;
    unsigned int size = 0;

    dirp = opendir(dirname);
    if (dirp == NULL) {
	signame = "not_possible";
	sigarg_area[0] = (elt)sys_errlist[errno];
	return(SIG);
    }
    start = telldir(dirp);

    for (dp = readdir(dirp); dp != NULL; dp = readdir(dirp))
	if (strcmp(dp->d_name, ".") && strcmp(dp->d_name, ".."))
	    size = size + dp->d_namlen + 1; 

    seekdir(dirp, start);
    /*
     *	Because an object being allocated doesn't contain any pointer,
     *	malloc_atomic is used rather than malloc, expecting better efficiency.
     */
    list = malloc_atomic((size + 1) * sizeof(char));
    list[0] = '\0';

    for (dp = readdir(dirp); dp != NULL; dp = readdir(dirp))
	if (strcmp(dp->d_name, ".") && strcmp(dp->d_name, "..")) {
	    list = strcat(list, dp->d_name);
	    list = strcat(list, " ");
	}

    closedir(dirp);
    retval_area[0] = (elt)list;
    return(RET);
}
