/*
 * $Id: _get_runtime.c,v 2.1 1992/03/16 19:49:39 ushijima Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/*
 * This should be called from run_time(CLU)
 * in clu2c compiler.
 *
 *	_get_runtime = proc() returns(int, int, int)
 *	end _get_runtime
 *
 * return user time of current process in sec, msec, usec.
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>
#include <sys/time.h>
#include <sys/resource.h>

int _p_get_runtime()
{
  struct rusage val;

  getrusage(0, &val);	/* get info of current process */
  retval_area[0] = (elt) val.ru_utime.tv_sec;
  retval_area[1] = (elt) val.ru_utime.tv_usec / 1000;
  retval_area[2] = (elt) val.ru_utime.tv_usec % 1000;
#undef DEBUG
#ifdef DEBUG
  printf("get_runtime: %d %d %d\n", retval_area[0], retval_area[1], retval_area[2]);
#endif
  return(RET);
}
