/*
 * $Id: file_exists.c,v 2.0 1992/09/23 09:27:24 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* file_exists = proc(fn: file_name) returns(bool)
 *				     signals(not_possible(string))
 *	% Tests existence of a file.
 * 	end file_exists
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <sys/file.h>
#include <sys/errno.h>

extern char* sys_errlist[];
extern int errno;

int _pfile_exists(clus fn)
{
    int except_level;
    string name;

    /*
     *	begin body
     */

    except_level = 0;

    /* fn := file_name_fill(fn, "") */
    if (_pfile_name_fill(fn, "") == SIG)
	goto sighandler;
    fn = (clus) retval_area[0];

    /* name: string := file_name$unparse(fn) */
    if (file_name_unparse(fn) == SIG)
	goto sighandler;
    name = (string) retval_area[0];

    if (access(name, F_OK) == 0) {
	/* return(true) */
	retval_area[0] = (elt) TRUE;
	return (RET);
    } else if (errno == ENOENT || errno == ENOTDIR) {
	/* return(false) */
	retval_area[0] = (elt) FALSE;
	return (RET);
    } else {
	/* signal not_possible(...) */
	sigarg_area[0] = (elt) sys_errlist[errno];
	signame = "not_possible";
	return (SIG);
    }

    /*
     *	end body
     */

    /*
     *	signal handler (exception hadler)
     */

 sighandler:
    switch (except_level) {
    case -1:
	string_concat("unhandle exception: ", signame);
	sigarg_area[0] = retval_area[0];
	signame = "failure";
	return (SIG);
    case 0:
	if (!strcmp(signame, "failure"))
	    return (SIG);
	else {
	    string_concat("unhandle exception: ", signame);
	    sigarg_area[0] = retval_area[0];
	    signame = "failure";
	    return (SIG);
	}
    }
}
