#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
CC        = $cc
CFLAGS    = $cflags -DSILENT
AR        = $ar
AS        = $as
INSTALL   = install
IFLAGS    = -c

ARCHIVE   = libgc.a
LIBDIR    = $libdir
TMPLIBDIR = ..

OBJS= alloc.o reclaim.o allochblk.o misc.o mach_dep.o mark_roots.o
# add rt_allocobj.o for RT version

SRCS= reclaim.c allochblk.c misc.c alloc.c mach_dep.c rt_allocobj.s mips_mach_dep.s mark_roots.c

# Set SPECIALCFLAGS to -q nodirect_code on Encore.
# On Sun systems under 4.0, it's probably safer to link with -Bstatic.
# I'm not sure that all static data will otherwise be found.
# It also makes sense to replace -O with -O4, though it doesn't appear
# to make much difference.

SPECIALCFLAGS = 

all: \$(ARCHIVE) gctest
	cp \$(ARCHIVE) \$(TMPLIBDIR)/\$(ARCHIVE)

\$(OBJS): gc.h

\$(ARCHIVE): \$(OBJS)
	\$(AR) ru \$(ARCHIVE) \$(OBJS)
	ranlib \$(ARCHIVE)

# mach_dep.c doesn't like optimization
# on a MIPS machine, move mips_mach_dep.s to mach_dep.s and remove
# mach_dep.c as well as the following two lines from this Makefile
EOF
if test $mips
then
	cat >>$target <<EOF
mach_dep.o: mips_mach_dep.s
	\$(AS) -o mach_dep.o mips_mach_dep.s
EOF
else
	cat >>$target <<EOF
mach_dep.o: mach_dep.c
	\$(CC) -c \${SPECIALCFLAGS} mach_dep.c
EOF
fi
	cat >>$target <<EOF

clean: 
	rm -f \$(ARCHIVE) test.o cons.o setjmp_test gctest output-local \\
		output-diff \$(OBJS) \$(TMPLIBDIR)/\$(ARCHIVE)

test.o: cons.h test.c

cons.o: cons.h cons.c

# On a MIPS system, the BSD version of libc.a should be used to get
# sigsetmask.  I found it necessary to link against the system V
# library first, to get a working version of fprintf.  But this may have
# been due to my failure to find the right version of stdio.h or some
# such thing.
gctest: test.o cons.o \$(ARCHIVE)
	\$(CC) \$(CFLAGS) -o gctest test.o cons.o \$(ARCHIVE)

setjmp_test: setjmp_test.c gc.h
	\$(CC) -o setjmp_test setjmp_test.c

test: setjmp_test gctest
	setjmp_test
	@echo "WARNING: for GC test to work, all debugging output must be turned off"
	rm -f output-local
	gctest > output-local
	-diff correct-output output-local > output-diff
	-@test -s output-diff && echo 'Output of program "gctest" is not correct.  GC does not work.' || echo 'Output of program "gctest" is correct.  GC probably works.' 
	
shar:
	makescript -o gc.shar README Makefile gc.h \${SRCS} test.c cons.c cons.h

install: \$(ARCHIVE) \$(LIBDIR)
	if test -f \$(LIBDIR)/\$(ARCHIVE);\
	then\
		cd \$(LIBDIR); mv \$(ARCHIVE) \$(ARCHIVE).old;\
	else\
		true;\
	fi
	\$(INSTALL) \$(IFLAGS) \$(ARCHIVE) \$(LIBDIR)

\$(LIBDIR):
	mkdir \$(LIBDIR)
	chmod 755 \$(LIBDIR)
	
EOF
echo ' done'
