/*
	The standard command states from concon.
*/	
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include "commands.fdf"
#include "manager.fdf"
#include "parser.fdf"
#include "states.fdf"
#include "service.fdf"
#include "input.fdf"
#include "format.fdf"
#include "methods.fdf"
#include "global.h"
#include "concon.h"
#include "manager.h"

long    cutPlace;
long    length;
List    *foundElementP;
Inherit jumpOver = FALSE; /* Will have to be encapsulated in state
					space if real parallel execution is to occur. */

void proCmd_exit( void )
	{
	programHalted = TRUE;
	stateP->actionFuncP = action_read;
	proState_stringToReturn( stateP, "TRUE" );
	}

void proCmd_mem( void )
	{
	proMem_memFree();
	stateP->actionFuncP = action_read;
	proState_stringToReturn( stateP, "TRUE" );
	}	

void proCmd_gc( void )
	{
	proMem_garbageCollect();
	stateP->actionFuncP = action_read;
	proState_stringToReturn( stateP, "TRUE" );
	}

void proCmd_write( void )
	{
	if (stateP->readP == NULL)
		proMem_displayList( stateP->returnP->nextP );
	general( FALSE );
	}

void proCmd_sym( void )
	{
	Descr *descrP;
	stateP->actionFuncP = action_read;
	descrP = proMem_getSymbolTable();
	proState_copySingleToReturn( stateP, descrP->nextP );
	cc_freeDescr( &descrP );
	}

void proCmd_setq( void )
	{
	setting( TRUE );
	}
	
void proCmd_set( void )
	{
	setting( FALSE );
	}

void setting( Inherit quotedBind )
	{
    if (stateP->readP == NULL)
        cc_set( quotedBind, stateP->returnP->nextP, stateP );
	general( FALSE ); 
	}

void proCmd_unbind( void )
	{
	if (stateP->readP == NULL)
		{
		proMem_processList( stateP->returnP->nextP, unbind, nofunc );
		proState_stringToReturn( stateP, "TRUE" );
		}
	general( FALSE );
	}

Inherit unbind( List *lP )
	{
	if (lP == NULL)
		return FALSE;
    if (lP->u.p.type == ALPHA)
		*cc_variable( stateP, lP ) = NULL;
	return FALSE;
	}

void proCmd_quote( void )
	{
	proState_appendToReturn( stateP, stateP->readP );
	stateP->readP = NULL;
	general( FALSE );
	}
	
void proCmd_eval( void )
	{
	if (stateP->readP == NULL)
		{
		stateP->actionFuncP = action_read;
		stateP->execP = stateP->readP = stateP->returnP->nextP;
		stateP->actionFuncP = action_read;
		proState_clearReturn( stateP );
		}
	general( FALSE );
	}

void proCmd_return( void )
	{
	if (stateP->readP == NULL)
		{
		State *prevP = stateP->prevStateP;
		proState_replaceReturn( prevP, stateP->returnP->nextP );
		prevP->writeP = NULL;
		proState_clearReturn( stateP );
		}
	general( FALSE );
	}

void proCmd_ref( void )
	{
	if (stateP->readP == NULL)
		{
		stateP->readP = stateP->returnP->nextP;
		proState_clearReturn( stateP );
		while (stateP->readP != NULL)
			{
			ref();
			stateP->readP = stateP->readP->nextP;
			}
		}
	general( FALSE );
	}


void ref( void )
	{
	List *traverserP;
    if (stateP->readP->u.p.type == ALPHA)
		{
		traverserP = *cc_variable( stateP, stateP->readP );
		while (traverserP != NULL)
			{
			proState_copySingleToReturn( stateP, traverserP );
			traverserP = traverserP->nextP;
			}
		}
	else
		proState_copySingleToReturn( stateP, stateP->readP );
	}


void proCmd_read( void )
	{
	Descr *descrP = proParse_parse();
	proState_appendToReturn( stateP, descrP->nextP );
	cc_freeDescr( &descrP );
	stateP->actionFuncP = action_read;
	}
	
void proCmd_head( void )
	{
	List new;

	if (stateP->readP == NULL)
		{
		List *currentP = stateP->returnP->nextP;
		
		stateP->actionFuncP = action_read;
		if (currentP == NULL)
			{
			proState_unaccept( stateP );
			return;
			}
        if (currentP->u.p.type != SUBLIST)
			{
			proState_unaccept( stateP );
			return;
			}
		currentP = currentP->data.dataP;
		if (currentP == NULL)
			cc_makeSubList( &new, NULL );
		else
			new = *currentP;
		new.nextP = NULL;
		proState_clearReturn( stateP );
		proState_copySingleToReturn( stateP, &new );
		}
	general( FALSE );
	}

void proCmd_tail( void )
	{
	List new;

	if (stateP->readP == NULL)
		{
		List *currentP = stateP->returnP->nextP;
		
		stateP->actionFuncP = action_read;
		if (currentP == NULL)
			{
			proState_unaccept( stateP );
			return;
			}
        if (currentP->u.p.type != SUBLIST)
			{
			proState_unaccept( stateP );
			return;
			}
		currentP = currentP->data.dataP;
		cc_clearLElm( &new );
		cc_makeSubList( &new, cc_binding( currentP ) );
		proState_clearReturn( stateP );
		proState_copySingleToReturn( stateP, &new );
		}
	general( FALSE );
	}

void proCmd_sin( void )
	{
	if (stateP->readP == NULL)
		apply( sin );
	general( FALSE );
	}
	
void proCmd_asin( void )
	{
	if (stateP->readP == NULL)
		apply( asin );
	general( FALSE );
	}
	
void proCmd_cos( void )
	{
	if (stateP->readP == NULL)
		apply( cos );
	general( FALSE );
	}
	
void proCmd_acos( void )
	{
	if (stateP->readP == NULL)
		apply( acos );
	general( FALSE );
	}
	
void proCmd_tan( void )
	{
	if (stateP->readP == NULL)
		apply( tan );
	general( FALSE );
	}
	
void proCmd_atan( void )
	{
	if (stateP->readP == NULL)
		apply( atan );
	general( FALSE );
	}
	
void proCmd_exp( void )
	{
	if (stateP->readP == NULL)
		apply( exp );
	general( FALSE );
	}
	
void proCmd_log( void )
	{
	if (stateP->readP == NULL)
		apply( log );
	general( FALSE );
	}
	
void apply( double ((*fie)(double x)) )
	{
	List new, *currentP = stateP->returnP->nextP;
	Real value;
    int  type;
	
	stateP->actionFuncP = action_read;
	cc_clearLElm( &new );
	if (currentP == NULL)
		{
		proState_unaccept( stateP );
		return;
		}
    type = currentP->u.p.type;

	if (type == INTEGER)
		value = (Real)currentP->data.integer;
	else
		if (type == REAL)
			value = currentP->data.real;
		else	
			{
			proState_unaccept( stateP );
			return;
			}
	cc_clearLElm( &new );
	cc_makeReal( &new, fie( value ) );
	proState_clearReturn( stateP );
	proState_copySingleToReturn( stateP, &new );
	}

void proCmd_add( void )
	{
	if (stateP->readP == NULL)
		operate( 0, adding );
	general( FALSE );
	}
	
void proCmd_sub( void )
	{
	if (stateP->readP == NULL)
		operate( 0, subbing );
	general( FALSE );
	}

void proCmd_mul( void )
	{
	if (stateP->readP == NULL)
		operate( 1, mulling );
	general( FALSE );
	}

void proCmd_div( void )
	{
	if (stateP->readP == NULL)
		operate( 1, divving );
	general( FALSE );
	}


void operate( int identity, void (*oper)(List *isP, List *newP ) )
	{
	List collect, new;
	
	List *traverserP = stateP->returnP->nextP;
	
	stateP->actionFuncP = action_read;
	cc_clearLElm( &collect );
	cc_makeInteger( &collect, identity );
	while (traverserP != NULL)
		{
		new = *traverserP;
        if (new.u.p.type != INTEGER &&
            new.u.p.type != REAL )
			{
			proState_unaccept( stateP );
			return;
			}
        if (new.u.p.type == REAL)
			cc_intToReal( &collect );
        if (collect.u.p.type == REAL)
			cc_intToReal( &new );
		oper( &collect, &new );
		traverserP = traverserP->nextP;
		}
	proState_clearReturn( stateP );
	proState_copySingleToReturn( stateP, &collect );
	}	




void adding( List *isP, List *newP )
	{
    if (isP->u.p.type == INTEGER)
		isP->data.integer += newP->data.integer;
    if (isP->u.p.type == REAL)
		isP->data.real    += newP->data.real;
	}
		
void subbing( List *isP, List *newP )
	{
    if (isP->u.p.type == INTEGER)
		isP->data.integer -= newP->data.integer;
    if (isP->u.p.type == REAL)
		isP->data.real    -= newP->data.real;
	}

void mulling( List *isP, List *newP )
	{
    if (isP->u.p.type == INTEGER)
		isP->data.integer *= newP->data.integer;
    if (isP->u.p.type == REAL)
		isP->data.real    *= newP->data.real;
	}

void divving( List *isP, List *newP )
	{
    if (isP->u.p.type == INTEGER)
		{
		cc_intToReal( isP  );
		cc_intToReal( newP );
		}
	isP->data.real /= newP->data.real;
	}

void proCmd_raise( void )
	{
	twoToOne( pow );
	}

void proCmd_mod( void )
	{
	twoToOne( fmod );
	}


void twoToOne( double (*fie)(double x, double y) )
	{
	List *xP, *yP;

	if (stateP->readP == NULL)
		{
		stateP->actionFuncP = action_read;
		xP = stateP->returnP->nextP;
		yP = cc_binding( xP );
		if (yP == NULL)
			{
			proState_unaccept( stateP );
			return;
			}
		cc_intToReal( xP );
		cc_intToReal( yP );
        if (xP->u.p.type != REAL || yP->u.p.type != REAL)
			{
			proState_unaccept( stateP );
			return;
			}
		xP->nextP = NULL;
		xP->data.real = fie( xP->data.real,
									 yP->data.real );
		}
	general( FALSE );
	}

void proCmd_srand( void )
	{
	if (stateP->readP == NULL)
		{
		List *toUseP = stateP->returnP->nextP;
		if (toUseP != NULL)
            if (toUseP->u.p.type == REAL)
				if (toUseP->data.real >= 0.0 &&
					toUseP->data.real <  1.0)
	        srand( (int)(toUseP->data.real * RAND_MAX) );
		proState_stringToReturn( stateP, "TRUE" );
		}
	general( FALSE );
	}

void proCmd_rand( void )
	{
	List new;
	
	stateP->actionFuncP = action_read;
	cc_clearLElm( &new );
	cc_makeReal( &new, ((Real)rand())/RAND_MAX );
	proState_copySingleToReturn( stateP, &new );
	}

void proCmd_list( void )
	{
	List new;
	if (stateP->readP == NULL)
		{
		cc_clearLElm( &new );
		cc_makeSubList( &new, stateP->returnP->nextP );
		proState_clearReturn( stateP );
		proState_copySingleToReturn( stateP, &new );
		}
	general( FALSE );
	}

void proCmd_clock( void )
	{
	List new;
	
	stateP->actionFuncP = action_read;
	cc_clearLElm( &new );
	cc_makeReal( &new, 
		(Real)(clock() - conConTimer) / CLOCKS_PER_SEC );
	proState_copySingleToReturn( stateP, &new );
	}

void proCmd_largerThan( void )
	{
	compare( larger, TRUE );
	}

void proCmd_smallerThan( void )
	{
	compare( smaller, TRUE );
	}

void proCmd_eq( void )
	{
	compare( cc_equalLElms, FALSE );
	}

void compare( Inherit (*cmp)(List *aP, List *bP), Inherit convToReal )
	{
	if (stateP->readP == NULL)
		{
		List *headP = stateP->returnP->nextP;
		List *tailP = cc_binding( headP );
		List first, second;
		
		stateP->actionFuncP = action_read;
		second = *headP;
		if (convToReal )
			{
			cc_intToReal( &second );
            if (second.u.p.type != REAL)
				{
				proState_unaccept( stateP );
				return;
				}
			}
		while (tailP != NULL)
			{
			first  = second;
			second = *tailP;
			if (convToReal )
				{
				cc_intToReal( &second );
                if (second.u.p.type != REAL)
					{
					proState_unaccept( stateP );
					return;
					}
				}
			if (!cmp( &first, &second))
				{
				proState_stringToReturn( stateP, "FALSE" );
				return;
				}			
			tailP = tailP->nextP;
			}	
		proState_stringToReturn( stateP, "TRUE" );
		}
	general( FALSE );
	}

Inherit larger( List *aP, List *bP )
	{
	return (aP->data.real > bP->data.real) ? 
			TRUE : FALSE;
	}
	
Inherit smaller( List *aP, List *bP )
	{
	return (aP->data.real < bP->data.real) ? 
			TRUE : FALSE;
	}

void proCmd_integerp( void )
	{
	testList( INTEGER );
	}

void proCmd_realp( void )
	{
	testList( REAL );
	}

void proCmd_listp( void )
	{
	testList( SUBLIST );
	}

void testList( int type )
	{
	if (stateP->readP == NULL)
		{
		List *traverserP = stateP->returnP->nextP;
		stateP->actionFuncP = action_read;
		if (traverserP == NULL)
			{
			proState_stringToReturn( stateP, "FALSE" );
			return;
			}
		while (traverserP != NULL)
			{
            if (traverserP->u.p.type != type)
				{
				proState_stringToReturn( stateP, "FALSE" );
				return;
				}
			traverserP = traverserP->nextP;
			}
		proState_stringToReturn( stateP, "TRUE" );		
		}
	general( FALSE );
	}

void proCmd_assoc( void )
	{
	if (stateP->readP == NULL)
		{
		List *handleP = stateP->returnP->nextP;
		List *aListP  = cc_binding( handleP );
		List new;
		Descr *descrP;
		
		cc_unbind( handleP );
		descrP = cc_assoc( handleP, aListP );
		if (descrP->nextP == NULL)
			{
			cc_clearLElm( &new );
			cc_makeAtom( &new, "FALSE" );
			cc_copyAndInsert( descrP, &new, FALSE );
			}
		proState_clearReturn( stateP );
		proState_replaceReturn( stateP, descrP->nextP );
		cc_freeDescr( &descrP );
		}
	general( FALSE );
	}

void proCmd_if( void )
	{
	if (stateP->returnP->nextP != NULL)
		stateP->actionFuncP = ifTested;
	else
		general( FALSE );
	}

void ifTested( void )
	{
	List  *trueExecP, *falseExecP;
	Descr *descrP;
	
	cc_newDescr( &descrP, NULL );
	cc_copyAndInsert( descrP, stateP->readP, FALSE );
	trueExecP  = cc_binding( descrP );
	falseExecP = cc_binding( trueExecP );
	cc_freeDescr( &descrP );
	trueExecP->nextP = NULL;
    stateP->actionFuncP = action_read;

    if (cc_equalLElms( trueDescrP->nextP, stateP->returnP->nextP )
			)
        {
        proState_clearReturn( stateP );
        stateP->execP = stateP->readP = trueExecP;
        }
    else
        if (falseExecP == NULL)
            {
            proState_clearReturn( stateP );
            stateP->readP = NULL;
            proState_stringToReturn( stateP, "FALSE" );
            }
        else
            {
            proState_clearReturn( stateP );
            stateP->execP = stateP->readP = falseExecP;
            }
    }

void proCmd_while( void )
	{
	if (stateP->returnP->nextP != NULL)
		stateP->actionFuncP = whileTested;
	else
		general( FALSE );
	}

void whileTested( void )
	{
	if (cc_equalLElms( trueDescrP->nextP, stateP->returnP->nextP ) 
		)
		{
		stateP->actionFuncP = whileExec;
		return;
		}
	else
		{
		stateP->readP = NULL;
		general( FALSE );
		}
	}

void whileExec( void )
	{
	if (stateP->readP == NULL)
		{
		proState_clearReturn( stateP );
		stateP->actionFuncP = proCmd_while;
		stateP->readP = cc_binding( stateP->execP );
		}
	else
		general( FALSE );
	}


/* The loaded file should end with a return. */
void proCmd_load( void )
	{
	if (stateP->readP == NULL)
		{
		stateP->actionFuncP = loadOpen;
		stateP->execP = stateP->readP = stateP->returnP->nextP;
		proState_clearReturn( stateP );
		}
	else
		general( FALSE );
	}

void loadOpen( void )
	{
	if (stateP->readP != NULL)
		{
        if (stateP->readP->u.p.type == LITERAL ||
            stateP->readP->u.p.type == ALPHA)
			proState_request( REQ_NEWSTATE, stateP->readP, 
					loadOpenSingle );
		stateP->readP = stateP->readP->nextP;
		}
	else
		{
		proState_stringToReturn( stateP, "TRUE" );
		general( FALSE );
		}
	}

void loadOpenSingle( void )
	{
	if (stateP->readP != NULL)
		{
		if (proInput_openFile( stateP->readP ) )
			{
			stateP->readP = NULL;
			proState_request( REQ_NEWSTATE, NULL, loadConsult );
			}
		}
	else
		general( FALSE );
	}

void loadConsult( void )
	{
	Descr *descrP;
	
	if (!(stateP->endOfFile))
		{
		descrP = proParse_parse();
		proState_request( REQ_NEWSTATE, descrP->nextP, action_read );
		cc_freeDescr( &descrP );
		}
	else
		general( FALSE );
	}

void proCmd_let( void )
	{
	if (stateP->readP == NULL)
		exit_state();
    if (stateP->readP->u.p.type != SUBLIST)
		exit_state();
	proState_request( REQ_NEWSTATE, 
		stateP->readP->data.dataP, letVars );
	stateP->readP = cc_binding( stateP->readP );
	stateP->actionFuncP = action_read;
	}

void letVars( void )
	{
	if (stateP->readP == NULL)
		{
		List new;
		Descr *descrP;
		
		cc_newDescr( &descrP, NULL );
		cc_clearLElm( &new );
		cc_makeSubList( &new, stateP->returnP->nextP );
		cc_copyAndInsert( descrP, &new, FALSE );
		proState_appendLocals( stateP, descrP->nextP );
		cc_freeDescr( &descrP );
		((State *)stateP->prevStateP)->localP = 
					   stateP->localP;
		proState_clearReturn( stateP );
		general( FALSE );
		}
	else
		{
		proState_request( REQ_NEWSTATE, 
		stateP->readP->data.dataP, letExec );
		stateP->readP = stateP->readP->nextP;
		}
	}	

void letExec( void )
	{
	if (stateP->readP == NULL)
		{
		Descr *descrP;
		cc_newDescr( &descrP, stateP->returnP->nextP );
		stateP->returnP->nextP = proMem_getAvail();
		cc_makeSubList( stateP->returnP->nextP, descrP->nextP );
		cc_freeDescr( &descrP );
		}
	general( FALSE );
	}

void proCmd_fork( void )
	{
	proState_request( REQ_NEWPROCESS, stateP->readP, action_read );
	stateP->actionFuncP = forked;
	stateP->readP = NULL;
	}

void forked( void)
	{
	int i;
	int process = -1;
	List new;
	
	for (i=1;i<stateSpaceSize;i++)
		if (stateSpaceP[i].parentProcess == stateP->process)
			process = stateSpaceP[i].process;
	if (process != -1)
		{
		cc_clearLElm( &new );
		cc_makeInteger( &new, process );
		proState_clearReturn( stateP );
		proState_copySingleToReturn( stateP, &new );
		stateP->actionFuncP = action_read;
		}
	}
	
void proCmd_unfork( void )
	{
	Descr *descrP;
	List *firstP = stateP->returnP->nextP;
	
	if (stateP->readP == NULL)
		{
		if (firstP == NULL)
			{
			proState_unaccept( stateP );
			return;
			}
        if (firstP->u.p.type != INTEGER)
			{
			proState_unaccept( stateP );
			return;
			}
		if ( 
			(descrP = proState_unfork( 
				(int)firstP->data.integer)) != NULL)
			{
			stateP->returnP->nextP = descrP->nextP;
			cc_freeDescr( &descrP );
			general( FALSE );
			}
		}
	else
		general( FALSE );
	}
	
void proCmd_title( void )
	{
	proState_assignTitle( stateP->readP );
	((State *)stateP->prevStateP)->titleP = 
				   stateP->titleP;
	proState_stringToReturn( stateP, "TRUE" );
	stateP->readP = NULL;
	general( FALSE );
	}
	
void proCmd_jobs( void )
	{
	Descr *descrP = proState_getJobList();
	stateP->returnP->nextP = descrP->nextP;
	proState_request( REQ_NEWSTATE, 
		((List *)descrP->nextP)->data.dataP, jobsExec );
	stateP->readP = NULL;
	stateP->actionFuncP = action_read;
	cc_freeDescr( &descrP );
	}

void jobsExec( void )
	{
	List *execP, *localP;
	
	if (stateP->returnP->nextP != NULL)
		{
		stateP->readP->data.dataP = 
			stateP->returnP->nextP;
		proState_clearReturn( stateP );
		stateP->readP = stateP->readP->nextP;
		}
	if (stateP->readP != NULL)
		{
		execP = stateP->readP->data.dataP;
		proState_request( REQ_NEWSTATE, execP, action_read );
		
		localP = stateP->readP->nextP;
		*(stateP->localP) = *localP;
		stateP->localP->nextP = NULL;
		stateP->readP->nextP = localP->nextP;
		}
	else
		general( FALSE );
	}

void proCmd_halt( void )
	{
	if (stateP->readP == NULL)
		{
		List *traverserP = stateP->returnP->nextP;
		while (traverserP != NULL)
			{
            if (traverserP->u.p.type == INTEGER)
				{
				int process = (int)traverserP->data.integer;
				State *stP = stateSpaceP;
				
				while (stP->nextProcessStateP != stateSpaceP && 
					   stP->process < process)
					   stP = stP->nextProcessStateP;
				if (stP->process == process && process > 0)
					stP->request = REQ_HALTED;
				}
			traverserP = traverserP->nextP;
			}
		proState_stringToReturn( stateP, "TRUE" );
		}
	general( FALSE );
	}

void proCmd_busyp( void )
	{
	if (stateP->readP == NULL)
		{
		List *lP = stateP->returnP->nextP;
		int process;
		State *stP = stateSpaceP;
		
		if (lP == NULL)
			{
			proState_stringToReturn( stateP, "FALSE" );
			general( FALSE );
			return;
			}
        if (lP->u.p.type != INTEGER)
			{
			proState_stringToReturn( stateP, "FALSE" );
			general( FALSE );
			return;
			}
		process = (int)lP->data.integer;
		if (process < 1)
			{
			proState_stringToReturn( stateP, "FALSE" );
			general( FALSE );
			return;
			}
		while (stP->nextProcessStateP != stateSpaceP && 
			   stP->process < process)
			   stP = stP->nextProcessStateP;
		if (stP->process == process)
			if (proState_processBusy( stP ) )
				{
				proState_stringToReturn( stateP, "TRUE" );
				general( FALSE );
				return;
				}
		proState_stringToReturn( stateP, "FALSE" );
		}
	general( FALSE );
	}
	
void proCmd_not( void )
	{
	if (stateP->readP == NULL)
		{
		if (cc_equalLElms( trueDescrP->nextP, 
				stateP->returnP->nextP ) )
			proState_stringToReturn( stateP, "FALSE" );
		else
			if (cc_equalLElms( falseDescrP->nextP, 
					stateP->returnP->nextP ) )
				proState_stringToReturn( stateP, "TRUE" );
			else
				proState_unaccept( stateP );
		}
	general( FALSE );
	}
		
void proCmd_and( void )
	{
	if (stateP->readP == NULL)
		{
		List *traverserP = stateP->returnP->nextP;
		
		while (traverserP != NULL)
			{
			if (cc_equalLElms( falseDescrP->nextP, traverserP ) 
				)
				{
				proState_stringToReturn( stateP, "FALSE" );
				general( FALSE );
				return;
				}
			if (!cc_equalLElms( trueDescrP->nextP, traverserP ))
				{
				proState_unaccept( stateP );
				general( FALSE );
				return;
				}
			traverserP = traverserP->nextP;
			}
		proState_stringToReturn( stateP, "TRUE" );
		}
	general( FALSE );
	}
		
void proCmd_or( void )
	{
	if (stateP->readP == NULL)
		{
		List *traverserP = stateP->returnP->nextP;
		
		while (traverserP != NULL)
			{
			if (cc_equalLElms( trueDescrP->nextP, traverserP ) 
				)
				{
				proState_stringToReturn( stateP, "TRUE" );
				general( FALSE );
				return;
				}
			if (!cc_equalLElms( falseDescrP->nextP, traverserP ))
				{
				proState_unaccept( stateP );
				general( FALSE );
				return;
				}
			traverserP = traverserP->nextP;
			}
		proState_stringToReturn( stateP, "FALSE" );
		}
	general( FALSE );
	}
		

void proCmd_lambda( void )
	{
	State *stP = stateP->prevStateP;
	List  *execP = cc_binding( stateP->readP );
	Descr *descrP;
	if (execP == NULL)
		{
		exit_state();
		return;
		}
    if (stateP->readP->u.p.type != SUBLIST)
		{
		exit_state();
		return;
		}
	if (stateP->readP->data.dataP == NULL)
		{
		stateP->execP = stateP->readP = stateP->execP->nextP;
		stateP->actionFuncP = action_read;
		return;
		}
	else
		{
		descrP = cc_copy( stateP->readP, TRUE );
		execP  = cc_binding( descrP->nextP );
		execP->nextP = stP->readP;
		stP->execP = descrP->nextP;
		stP->readP = execP;
		stP->actionFuncP = lambdaRetrieve;
		stateP->readP = NULL;
		cc_freeDescr( &descrP );
		general( FALSE );
		}
	}

void lambdaRetrieve( void )
	{
	State *stP = stateP->prevStateP;

	if (stateP->readP->nextP == NULL)
		{
		if (stateP->prevStateP == stateSpaceP)
			{
			exit_state();
			return;
			}
		stateP->readP->nextP = stP->readP;
		stP->execP    = stateP->execP;
		stP->readP    = stateP->readP;
		stP->actionFuncP = lambdaRetrieve;
		stateP->readP = NULL;
		general( FALSE );
		}
	else
		{
		stateP->actionFuncP = lambdaExecParams;
		stateP->readP       = stateP->readP->nextP;
		}
	}

void lambdaExecParams( void )
	{
	Descr *descrP;
	Descr *parDescrP;

	if (stateP->readP != NULL)
		general( FALSE );
	else
		{
		cc_newDescr( &parDescrP, NULL );
        parDescrP->nextP = proMem_getAvailAndCopy( stateP->execP );
		((List *)parDescrP->nextP)->nextP = NULL;
		descrP = cc_matchParams( parDescrP->nextP, 
					stateP->returnP->nextP );
		proState_appendLocals( stateP, descrP->nextP );
		cc_freeDescr( &descrP );
		cc_freeDescr( &parDescrP );
		stateP->execP = stateP->readP = stateP->execP->nextP;
		stateP->execP->nextP = NULL;
		stateP->actionFuncP = action_read;
		proState_clearReturn( stateP );
		}
	}

	
void proCmd_macro( void )
	{
	State *stP = stateP->prevStateP;
	List  *execP = cc_binding( stateP->readP );
	Descr *descrP;
	if (execP == NULL)
		{
		exit_state();
		return;
		}
    if (stateP->readP->u.p.type != SUBLIST)
		{
		exit_state();
		return;
		}
	if (stateP->readP->data.dataP == NULL)
		{
		stateP->execP = stateP->readP = stateP->execP->nextP;
		stateP->actionFuncP = action_read;
		return;
		}
	else
		{
		descrP = cc_copy( stateP->readP, TRUE );
		execP  = cc_binding( descrP->nextP );
		execP->nextP = stP->readP;
		stP->execP = descrP->nextP;
		stP->readP = execP;
		stP->actionFuncP = macroRetrieve;
		stateP->readP = NULL;
		cc_freeDescr( &descrP );
		general( FALSE );
		}
	}
	
void macroRetrieve( void )
	{
	Descr *descrP, *parDescrP, *valDescrP;
	
	State *stP = stateP->prevStateP;

	if (stateP->readP->nextP == NULL)
		{
		if (stateP->prevStateP == stateSpaceP)
			{
			exit_state();
			return;
			}
		stateP->readP->nextP = stP->readP;
		stP->execP    = stateP->execP;
		stP->readP    = stateP->readP;
		stP->actionFuncP = macroRetrieve;
		stateP->readP = NULL;
		general( FALSE );
		}
	else
		{
		stateP->readP       = stateP->readP->nextP;

		cc_newDescr( &parDescrP, NULL );
        parDescrP->nextP = proMem_getAvailAndCopy( stateP->execP );
		((List *)parDescrP->nextP)->nextP = NULL;

		valDescrP = cc_copy( stateP->readP, TRUE );
		descrP = cc_matchParams( parDescrP->nextP, 
								 valDescrP->nextP ); 
		stateP->execP = stateP->execP->nextP;
		stateP->execP->nextP = NULL;

		proState_substitute( descrP->nextP );
		cc_freeDescr( &descrP );
		cc_freeDescr( &valDescrP );
		cc_freeDescr( &parDescrP );
		stateP->actionFuncP = action_read;
		}
	}

void proCmd_flat( void )
	{
	if (stateP->readP == NULL)
		{
		List *traverserP = stateP->returnP;
		List *keepP;
		while (traverserP->nextP != NULL)
            if (((List *)traverserP->nextP)->u.p.type == SUBLIST)
				{
				keepP = ((List *)traverserP->nextP)->nextP;
				traverserP->nextP = 
					((List *)traverserP->nextP)->data.dataP;
				while (traverserP->nextP != NULL)
					traverserP = traverserP->nextP;
				traverserP->nextP = keepP;
				}
			else
				traverserP = traverserP->nextP;
		}
	general( FALSE );
	}

void proCmd_tell( void )
	{
	if (stateP->returnP->nextP != NULL)
		{
		if (proFor_openFile( stateP->returnP->nextP ) != FALSE)
			{
			proState_clearReturn( stateP );
			stateP->actionFuncP = action_read;
			}
		}
	else
		general( FALSE );
	}

void proCmd_hear( void )
	{
	if (stateP->returnP->nextP != NULL)
		{
		if (proInput_openFile( stateP->returnP->nextP ) != FALSE)
			{
			proState_clearReturn( stateP );
			stateP->actionFuncP = action_read;
			}
		}
	else
		general( FALSE );
	}

void proCmd_mapcar( void )
	{
	if (stateP->readP == NULL)
		{
		stateP->actionFuncP = mapcarReturn;
		proState_request( REQ_NEWSTATE, stateP->returnP->nextP,
			mapcarOn );
		proState_clearReturn( stateP );
		}
	else
		general( FALSE );
	}

void mapcarReturn( void )
	{
	Descr *descrP;

	cc_newDescr( &descrP, NULL );
	descrP->nextP = proMem_getAvail();
	cc_makeSubList( descrP->nextP, stateP->returnP->nextP );
	proState_clearReturn( stateP );
	proState_copySingleToReturn( stateP, descrP->nextP );
	cc_freeDescr( &descrP );
	stateP->readP = NULL;
	general( FALSE );
	}

void mapcarOn( void )
	{
	List *traverserP = stateP->execP;
	List *writerP;
	Descr *comDescrP, *eListDescrP;

	cc_newDescr( &comDescrP, NULL );
	writerP = comDescrP;
    writerP->nextP = proMem_getAvailAndCopy( traverserP );
	writerP = writerP->nextP;
	writerP->nextP = NULL;
	traverserP = traverserP->nextP;
	
	while (traverserP != NULL)
		{
        if (traverserP->u.p.type == SUBLIST)
			if (traverserP->data.dataP != NULL)
				{
                writerP->nextP =
                    proMem_getAvailAndCopy( traverserP->data.dataP );
				writerP = writerP->nextP;
				writerP->nextP = NULL;
                writerP->u.p.quoted = TRUE;
				traverserP->data.dataP = 
					((List *)traverserP->data.dataP)->nextP;
				}
		traverserP = traverserP->nextP;
		}
	if ( ((List *)comDescrP->nextP)->nextP != NULL)
		{
		cc_newDescr( &eListDescrP, NULL );
		eListDescrP->nextP = proMem_getAvail();
		cc_makeSubList( eListDescrP->nextP, comDescrP->nextP );
		proState_request( REQ_NEWSTATE, eListDescrP->nextP, 
				action_read );
		cc_freeDescr( &eListDescrP );
		}
	else
		{
		stateP->readP = NULL;
		general( FALSE );
		}
	cc_freeDescr( &comDescrP );
	}


void proCmd_select( void )
	{
	if (stateP->readP == NULL)
		{
	    float index, count;
    	List *traverserP;
	    List indexLElm;
    	List *listP;
		if (stateP->returnP->nextP == NULL)
			{
			proState_unaccept( stateP );
			return;
			}
    	indexLElm = *((List *)stateP->returnP->nextP);
    	listP = cc_binding( &indexLElm );
		cc_intToReal( &indexLElm );
		if (listP == NULL)
			{
			proState_unaccept( stateP );
			return;
			}
        if (indexLElm.u.p.type == REAL &&
            listP->u.p.type == SUBLIST)
			index = indexLElm.data.real;
		else
			{
			proState_unaccept( stateP );
			return;
			}
	    traverserP = listP->data.dataP;
		count = get_weight( traverserP );
 	   	while (traverserP->nextP != NULL && count < index)
    	    {
        	traverserP = traverserP->nextP;
	        count += get_weight( traverserP );
 	   	    }
		proState_clearReturn( stateP );
	    if (traverserP != NULL)
    	    {
			List new;
			cc_clearLElm( &new );
			cc_makeSubList( &new, traverserP->data.dataP );
        	proState_copySingleToReturn( stateP, &new );
        	}
    	else
    	    proState_unaccept( stateP );
 		}
	general( FALSE );
	}

float get_weight( List *lP )
    {
    List new;
    
    if (lP == NULL)
        return 0.0;
    if (lP->u.p.type != SUBLIST)
        return 0.0;
    lP = lP->data.dataP;
    lP = cc_binding( lP );
    new = *lP;
    cc_intToReal( &new );
    if (new.u.p.type != REAL)
    	return 0.0;
    else
        return new.data.real;
    }


void proCmd_swap( void )
	{
	if (stateP->readP == NULL)
		{
	    List *firstP     ,   *secondP;
    	List *firstValueP,   *secondValueP;
	    List *firstElementP, *secondElementP;
	    List *keepNextP;
	    Descr *frstdP, *scnddP, *frstValdP, *scndValdP,
	    *firstSubstdP, *secondSubstdP;
	    
	    frstdP = cc_copy( stateP->returnP->nextP, TRUE );
    	firstP = frstdP->nextP;
    	firstValueP  = cc_binding( firstP );
	    secondP      = cc_binding( firstValueP );
    	secondValueP = cc_binding( secondP );

/*  Enough parameters ? */
	    if (secondValueP == NULL)
    	    {
			cc_freeDescr( &frstdP );
    	    proState_unaccept( stateP );
    	    return;
    	    }

/*  The lists to swap in valid ? The cut places valid ? */
        if (firstP->u.p.type != SUBLIST    ||
            secondP->u.p.type != SUBLIST   ||
            firstValueP->u.p.type  != REAL ||
            secondValueP->u.p.type != REAL)
    	    {
 			cc_freeDescr( &frstdP );
	   	    proState_unaccept( stateP );
    	    return;
    	    }

/*  Separate the parameters. */
		cc_newDescr( &scnddP, secondP );
		cc_newDescr( &frstValdP, firstValueP );
		cc_newDescr( &scndValdP, secondValueP );
	    firstP->nextP      = secondP->nextP =
    	firstValueP->nextP = secondValueP->nextP = NULL;

 /* Find the element in the first list to be swapped. */
 	    length = 0L;
    	proMem_processList( firstP, listLength, nofunc );

	    cutPlace = (long)(length * firstValueP->data.real)+1;
    	length   = 0L;
		jumpOver = FALSE;
    	foundElementP = NULL;
    	proMem_processList( firstP, findElement, nofunc );
    	firstElementP = foundElementP;

/* Find the element in the second list to be swapped. */
	    length = 0L;
    	proMem_processList( secondP, listLength, nofunc );

	    cutPlace = (long)(length * secondValueP->data.real)+1;
    	length   = 0L;
	    jumpOver = FALSE;
    	foundElementP = NULL;
    	proMem_processList( secondP, findElement, nofunc );
    	secondElementP = foundElementP;

/*  Do the swapping here. */
	    if (firstElementP != NULL && secondElementP != NULL)
    	    {
    	    keepNextP     =   secondElementP->nextP;
        	secondElementP->nextP = NULL;
        	firstSubstdP   = cc_copy( secondElementP, TRUE );
        	secondElementP->nextP = keepNextP;
        	((List *)firstSubstdP->nextP)->nextP = 
        		firstElementP->nextP;

        	keepNextP     =   firstElementP->nextP;
        	firstElementP->nextP = NULL;
        	secondSubstdP = cc_copy( firstElementP, TRUE );
        	firstElementP->nextP = keepNextP;
        	((List *)secondSubstdP->nextP)->nextP = 
        		secondElementP->nextP;

	       	*firstElementP  = *((List *)firstSubstdP->nextP);
        	*secondElementP = *((List *)secondSubstdP->nextP);
			cc_freeDescr( &firstSubstdP );
			cc_freeDescr( &secondSubstdP );
        	}
    	firstP->nextP = secondP;
		proState_clearReturn( stateP );
		proState_appendToReturn( stateP, firstP );
		cc_freeDescr( &frstdP );
		cc_freeDescr( &scnddP );
		cc_freeDescr( &frstValdP );
		cc_freeDescr( &scndValdP );
		}
	general( FALSE );
	}

Inherit listLength( List *lP )
    {
    if (lP->u.p.type != SUBLIST)
        length += 1L;
    return FALSE;
    }

Inherit findElement( List *lP )
    {
/*  Skip the operators, to keep the list formally correct (if it already
    was). */
    if (jumpOver )
        return (jumpOver = FALSE);

    if (lP->u.p.type == SUBLIST)
        jumpOver = TRUE;
    length += 1L;
    if (length == cutPlace)
        {
        foundElementP = lP;
        return TRUE;
        }
     return FALSE;
    }

void proCmd_atomize( void )
	{
	if (stateP->readP == NULL)
			proMem_processList( stateP->returnP, makeatom, nofunc );
	general( FALSE );
	}

Inherit makeatom( List *lP )
	{
	List *newP;

	stateP->token = ALPHA;
    switch (lP->u.p.type)
		{
		case INTEGER:
			sprintf( lexTailP, "%ld", lP->data.integer );
			if ( (newP = proMem_lookup( lexTailP )) == NULL)
				newP = proMem_insert();
            newP->u.p.type = ALPHA;
			lP->data.dataP = newP;
            lP->u.p.type = ALPHA;
			break;
		case REAL:
			sprintf( lexTailP, "%.8g", lP->data.real );
			if ( (newP = proMem_lookup( lexTailP )) == NULL)
				newP = proMem_insert();
            newP->u.p.type = ALPHA;
			lP->data.dataP = newP;
            lP->u.p.type = ALPHA;
			break;
		default:
			break;
		}
	return FALSE;
	}

void proCmd_explode( void )
	{
	if (stateP->readP == NULL)
		{
		List  *listP = stateP->returnP->nextP;
		Descr *toRetDescrP;
		List *newP, **listTailPP;
		char *lexP;
	
		cc_newDescr( &toRetDescrP, NULL );
	    listTailPP = (List **)&toRetDescrP->nextP;
		while (listP != NULL)
			{
            stateP->token = listP->u.p.type;
            switch (listP->u.p.type)
				{
				case LITERAL:
					lexP = ((List *)listP->data.dataP)->
										data.dataP;
					lexP++;
					while (strlen( lexP ) > 1)
						{
						lexTailP[0] = lexTailP[2] = '\"';
						lexTailP[1] = *lexP++;
						lexTailP[3] = '\0';
						if ((newP = proMem_lookup( lexTailP ))
								 == NULL)
							newP = proMem_insert();
                        (*listTailPP) = proMem_getAvail();
                        (*listTailPP)->u.p.type = LITERAL;
						(*listTailPP)->data.dataP = newP;
            	        listTailPP = (List **)&(*listTailPP)->nextP;
						}
					break;
				case ALPHA:
					lexP = ((List *)listP->data.dataP)->
										data.dataP;
					while (strlen( lexP ) > 0)
						{
						lexTailP[0] = *lexP++;
						lexTailP[1] = '\0';

						(*listTailPP) = proMem_getAvail( );
						cc_makeAtom( (*listTailPP), lexTailP );
        	            listTailPP = (List **)&(*listTailPP)->nextP;
						}
					break;
				default:
					break;
				}
			listP = listP->nextP;
			}
		stateP->returnP->nextP = toRetDescrP->nextP;
		cc_freeDescr( &toRetDescrP );
		}
	general( FALSE );
	}
	
void proCmd_implode( void )
	{
	if (stateP->readP == NULL)
		{
		List *listP = stateP->returnP->nextP;
		Descr *toRetDescrP;
		List *newP, **listTailPP;
		char *lexP, *newLexP;
		Inherit busy;

		cc_newDescr( &toRetDescrP, NULL );
    	listTailPP = (List **)&toRetDescrP->nextP;
		while (listP != NULL)
			{
            stateP->token = listP->u.p.type;
            switch (listP->u.p.type)
				{
				case LITERAL:
					lexP = ((List *)listP->data.dataP)->
									data.dataP;
					newLexP = lexTailP;
					newLexP[0] = '\"';
					newLexP++;

					busy = TRUE;
					while (busy  && listP != NULL)
                        if (listP->u.p.type == LITERAL)
							{
							lexP = ((List *)listP->data.dataP)->
										data.dataP;
							lexP++;
							strcpy( newLexP, lexP );
							newLexP += strlen( newLexP ) - 1;
							listP = listP->nextP;
							}
						else
							busy = FALSE;
		
					newLexP[0] = '\"';
					newLexP[1] = '\0';
					if ((newP = proMem_lookup( lexTailP ))
							 == NULL)
						newP = proMem_insert();
					(*listTailPP) = proMem_getAvail( );
                    (*listTailPP)->u.p.type = LITERAL;
					(*listTailPP)->data.dataP = newP;
                	listTailPP = (List **)&(*listTailPP)->nextP;
					break;
				case ALPHA:
					lexP = ((List *)listP->data.dataP)->
										data.dataP;
					newLexP = lexTailP;
					busy = TRUE;
					while (busy && listP != NULL)
                        if (listP->u.p.type == stateP->token)
							{
							lexP = ((List *)listP->data.dataP)->
										data.dataP;
							strcpy( newLexP, lexP );
							newLexP += strlen( newLexP );
							listP = listP->nextP;
							}
						else
							busy = FALSE;
	
					newLexP[0] = '\0';
					(*listTailPP) = proMem_getAvail( );
					cc_makeAtom( (*listTailPP), lexTailP );
        	        listTailPP = (List **)&(*listTailPP)->nextP;
					break;
				default:
					listP = listP->nextP;
					break;
				}
			}
		stateP->returnP->nextP = toRetDescrP->nextP;
		cc_freeDescr( &toRetDescrP );
		}
	general( FALSE );
	}

void proCmd_inside( void )
	{
	if (stateP->readP == NULL)
		{
		int process, curProcess;
		State *stP = stateSpaceP;
		List *toExecP = stateP->returnP->nextP;
		
		if (toExecP != NULL)
            if (toExecP->u.p.type == INTEGER)
			{
			process = (int)toExecP->data.integer;
			toExecP = toExecP->nextP;
			do
				{
				stP = stP->nextProcessStateP;
				curProcess = stP->process;
				} 
			while (stP->nextProcessStateP != stateSpaceP && 
				   curProcess < process);
			if (curProcess == process)
				{
				stateP->execP = stateP->readP = toExecP;
                stateP->localP = proMem_getAvailAndCopy( stP->localP );
				proState_clearReturn( stateP );
				stateP->actionFuncP = action_read;
				}
			}
		}
	else
		general( FALSE );
	}


void proCmd_remove( void )
	{
	if (stateP->readP == NULL)
		{
		List *traverserP = stateP->returnP->nextP;
		char *nameP;
		
		while (traverserP != NULL)
			{
            if (traverserP->u.p.type == LITERAL)
				{
				nameP = ((List *)traverserP->data.dataP)->data.dataP;
				nameP[strlen(nameP)-1] = '\0';
				remove( &nameP[1] );
				nameP[strlen(nameP)] = '\"';
				}
            if (traverserP->u.p.type == ALPHA)
				remove( ((List *)traverserP->data.dataP)->
					data.dataP );
			traverserP = traverserP->nextP;
			}
		}
	general( FALSE );
	}


/*
	Formatting by user.
*/
void proCmd_indent( void )
	{
	if (stateP->readP == NULL)
		proFor_indent( );
	general( FALSE );
	}

void proCmd_undent( void )
	{
	if (stateP->readP == NULL)
		proFor_undent( );
	general( FALSE );
	}

void proCmd_tabulate( void )
	{
	if (stateP->readP == NULL)
		proFor_tabulate( );
	general( FALSE );
	}

void proCmd_nl( void )
	{
	if (stateP->readP == NULL)
		proFor_newLine( );
	general( FALSE );
	}

void proCmd_display( void )
	{
	if (stateP->readP == NULL)
		displayable( stateP->returnP->nextP );
	general( FALSE );
	}
	
void proCmd_stack( void )
	{
    Descr *descrP;

	if (stateP->readP == NULL)
		{
        if (((List *)stateP->returnP->nextP)->u.p.type == INTEGER)
			{
			int process = (int)((List *)stateP->returnP->nextP)->
							data.integer;
			State *stP = stateSpaceP;
			
			while (stP->nextProcessStateP != stateSpaceP && 
				   stP->process < process)
				   stP = stP->nextProcessStateP;
			if (stP->process == process && process > 0)
                {
                descrP = proState_getStackList( stP );
                stateP->returnP->nextP = descrP->nextP;
                stateP->writeP = NULL;
                cc_freeDescr( &descrP );
                }
            }
        }
	general( FALSE );
	}

void proCmd_boundp( void )
	{
	if (stateP->readP == NULL)
		{
		List **lPP = cc_variable( stateP, stateP->returnP->nextP );
		
		if (lPP == NULL)
			proState_stringToReturn( stateP, "FALSE" );
		else
			if (*lPP == NULL)
				proState_stringToReturn( stateP, "FALSE" );
			else
				proState_stringToReturn( stateP, "TRUE" );
		}
	general( FALSE );
	}

void proCmd_setTail( void )
	{
	if (stateP->readP == NULL)
		{
		List *lP = stateP->returnP->nextP, 
			 *tailP = cc_binding( lP ),
			 *keepP = lP;
		List new;
		Descr *argDescrP;
		
		cc_newDescr( &argDescrP, stateP->returnP->nextP );
		cc_clearLElm( &new );
		cc_makeSubList( &new, NULL );
		proState_clearReturn( stateP );
		proState_copySingleToReturn( stateP, &new );
		
		if (lP != NULL)
            if (lP->u.p.type == SUBLIST)
				{
				lP = lP->data.dataP;
				if (lP != NULL)
					lP->nextP = tailP;
				keepP->nextP = NULL;
				*((List *)stateP->returnP->nextP) = *keepP;
				}
		cc_freeDescr( &argDescrP );
		}
	general( FALSE );
	}

void proCmd_length( void )
	{
	if (stateP->readP == NULL)
        {
        List *traverserP = stateP->returnP->nextP;
        long length = 0;
        List new;

        if (traverserP->u.p.type == SUBLIST)
            {
            traverserP = traverserP->data.dataP;
            while (traverserP != NULL)
                {
                length++;
                traverserP = traverserP->nextP;
                }
            }
        proState_clearReturn( stateP );
        cc_clearLElm( &new );
        cc_makeInteger( &new, length );
        proState_copySingleToReturn( stateP, &new );
        }
	general( FALSE );
    }

void proCmd_reverse( void )
	{
	if (stateP->readP == NULL)
        {
        List *traverserP = stateP->returnP->nextP;
        List *holdP  = traverserP;
        List *prevP = NULL, *nextP;
        Descr *descrP;

        if (traverserP->u.p.type == SUBLIST)
            {
            descrP = cc_copy( traverserP->data.dataP, FALSE );
            traverserP = descrP->nextP;
            while (traverserP != NULL)
                {
                nextP = traverserP->nextP;
                traverserP->nextP = prevP;
                prevP = traverserP;
                traverserP = nextP;
                }
            holdP->data.dataP = prevP;
            cc_freeDescr( &descrP );
            }
        }
	general( FALSE );
    }

void proCmd_copy( void )
	{
	if (stateP->readP == NULL)
        {
        Descr *descrP = cc_copy( stateP->returnP->nextP, TRUE );

        proState_clearReturn( stateP );
        proState_appendToReturn( stateP, descrP->nextP );
        cc_freeDescr( &descrP );
        }
	general( FALSE );
    }

void proCmd_cond( void )
    {
    if (stateP->readP != NULL)
        {
        if (stateP->returnP->nextP == NULL ||
            cc_equalLElms( falseDescrP->nextP, stateP->returnP->nextP ) )
            {
            if (stateP->readP->u.p.type == SUBLIST)
                {
                proState_clearReturn( stateP );
                proState_request( REQ_NEWSTATE,
                    stateP->readP->data.dataP, proCmd_if );
                }
            stateP->readP = stateP->readP->nextP;
            }
        else
            stateP->readP = NULL;
        }
    else
        general( FALSE );
    }

void proCmd_nextCond( void )
    {
    State *stP = stateP;

    while (stP->actionFuncP != proCmd_cond && stP != stateSpaceP )
        stP = stP->prevStateP;
    if (stP == stateSpaceP)
        {
        proState_stringToReturn( stateP, "FALSE" );
        stateP->readP = NULL;
        general( FALSE );
        }
    else
        {
        stateP->readP = stP->readP;
        stateP->actionFuncP = proCmd_cond;
        stP->readP = NULL;
        }
    }

void proCmd_defMethod( void )
    {
    if (stateP->readP == NULL)
        {
        if (proMeth_assertMethod( stateP->returnP->nextP ) == TRUE)
            proState_stringToReturn( stateP, "TRUE" );
        else
            proState_stringToReturn( stateP, "FALSE" );
        }
    general( FALSE );
    }

void proCmd_defProcedure( void )
    {
    if (stateP->readP == NULL)
        {
        if (proMeth_assertProcedure( stateP->returnP->nextP ) == TRUE)
            proState_stringToReturn( stateP, "TRUE" );
        else
            proState_stringToReturn( stateP, "FALSE" );
        }
    general( FALSE );
    }


void proCmd_abs( void )
	{
	if (stateP->readP == NULL)
        proMem_processList( stateP->returnP->nextP, absAll, nofunc );
	general( FALSE );
	}

Inherit absAll( List *lP )
	{
	if (lP == NULL)
		return FALSE;
    switch (lP->u.p.type)
        {
        case INTEGER:
            if (lP->data.integer < 0) lP->data.integer = -lP->data.integer;
            break;
        case REAL:
            if (lP->data.real < 0.0)  lP->data.real    = -lP->data.real;
            break;
        default:
            break;
        }
	return FALSE;
    }


void proCmd_removeMethod( void )
    {
    if (stateP->readP == NULL)
        {
        if (proMeth_removeMethod( stateP->returnP->nextP ) == NULL)
            proState_stringToReturn( stateP, "FALSE" );
        else
            proState_stringToReturn( stateP, "TRUE" );
        }
    general( FALSE );
    }

void proCmd_moveMethod( void )
    {

    if (stateP->readP == NULL)
        {
        List *toMoveP, *traverserP;

        if (cc_binding( cc_binding( stateP->returnP->nextP )) == NULL)
            {
            proState_stringToReturn( stateP, "FALSE" );
            general( FALSE );
            return;
            }
        if ( (toMoveP = proMeth_removeMethod( stateP->returnP->nextP ))
             == NULL)
            proState_stringToReturn( stateP, "FALSE" );
        else
            {
            traverserP = cc_binding( cc_binding( stateP->returnP->nextP ));
            ((List *)stateP->returnP->nextP)->nextP = traverserP;
            traverserP->nextP = toMoveP;
            if (proMeth_assertMethod( stateP->returnP->nextP ) == TRUE)
                proState_stringToReturn( stateP, "TRUE" );
            else
                proState_stringToReturn( stateP, "FALSE" );
            }
        }
    general( FALSE );
    }

void proCmd_error( void )
    {
    if (stateP->readP == NULL)
        {
        Descr *descrP;
        List new;

        cc_newDescr( &descrP, stateP->returnP->nextP );
        cc_clearLElm( &new );
        cc_makeAtom( &new, "USER-ERROR:" );
        cc_copyAndInsert( descrP, &new, FALSE );
        proMem_displayList( descrP->nextP );
        proState_assignTitle( descrP->nextP );
        proState_request( REQ_ERROR, NULL, nofunc );
        cc_freeDescr( &descrP );
        }
    else
        general( FALSE );
    }

void proCmd_writeLiteral( void )
	{
	if (stateP->readP == NULL)
        proMem_processList( stateP->returnP->nextP, writeLiteral, nofunc );
	general( FALSE );
	}

Inherit writeLiteral( List *lP )
	{
	if (lP == NULL)
		return FALSE;
    if (lP->u.p.type == LITERAL)
        {
        char *sP = (char *)((List *)lP->data.dataP)->
                         data.dataP;
        sP[strlen(sP)-1] = '\0';
        proFor_print( &sP[1] );
        sP[strlen(sP)] = '\"';
        }
    return FALSE;
    }



void proCmd_dotimes( void )
    {
    List newInt, newVar, aList;
    Descr *localDescrP = NULL, *allDescrP = NULL;
    List *traverserP = stateP->returnP->nextP;

/* Test for input. */
    if (stateP->readP != NULL)
        {
        action_read();
        return;
        }
    stateP->actionFuncP = action_read;

    if (traverserP->u.p.type != ALPHA)
        {
        proState_unaccept( stateP );
        return;
        }

    traverserP = traverserP->nextP;
    if (traverserP == NULL)
        {
        proState_unaccept( stateP );
        return;
        }

    if (traverserP->u.p.type != INTEGER)
        {
        proState_unaccept( stateP );
        return;
        }

    cc_clearLElm( &newInt );
    cc_clearLElm( &newVar );
    cc_clearLElm( &aList );

    cc_makeInteger( &newInt, 0 );

/* Assign the local variable. */
    cc_newDescr( &localDescrP, NULL );
    localDescrP->nextP  = proMem_getAvail();
    traverserP          = localDescrP->nextP;
    *traverserP         = *((List *)stateP->returnP->nextP);
    traverserP->nextP   = proMem_getAvail();
    traverserP          = traverserP->nextP;
    *traverserP         = newInt;
    cc_makeSubList( &aList, localDescrP->nextP );
    cc_copyAndInsert( localDescrP, &aList, FALSE );
    traverserP          = localDescrP->nextP;
    traverserP->nextP   = NULL;
    cc_newDescr( &allDescrP, NULL );
    allDescrP->nextP    = proMem_getAvail();
    cc_makeSubList( allDescrP->nextP, localDescrP->nextP );
    cc_freeDescr( &localDescrP );
    proState_appendLocals( stateP, allDescrP->nextP );

    cc_clearDescr( allDescrP );
    cc_makeInteger( &newInt, -1 );
    cc_copyAndInsert( allDescrP, &newInt, FALSE );
    traverserP = allDescrP->nextP;
    traverserP->nextP = stateP->returnP->nextP;
    proState_request( REQ_NEWSTATE, traverserP, dotimesLoop );
    proState_clearReturn( stateP );
    cc_freeDescr( &allDescrP );
    }

void dotimesLoop( void )
    {
    List *variableP  = stateP->readP->nextP;
    List *untilP     = variableP->nextP;
    List **varToPP;

    stateP->readP->data.integer += 1;
    if (stateP->readP->data.integer == untilP->data.integer)
        {
        proState_clearReturn( stateP );
        *stateP->readP = *((List *)untilP->nextP);
        stateP->readP->nextP = NULL;
        stateP->actionFuncP = action_read;
        return;
        }
    varToPP = cc_variable( stateP, variableP );
    if (*varToPP == NULL)
        *varToPP = proMem_getAvail();
    (*varToPP)->data.integer = stateP->readP->data.integer;
    ((List *)*varToPP)->nextP = NULL;

    proState_request( REQ_NEWSTATE,
            ((List *)untilP->nextP)->nextP, action_read );
    }


