/*
	Format.c arranges the output of lists.
*/

#include <stdio.h>
#include <string.h>
#include "format.fdf"
#include "states.fdf"
#include "manager.fdf"
#include "concon.h"
#include "global.h"

int maxWidth = 72,
	maxIndent = 16,
	indent   = 0,
	tabSize  = 4,
	curX     = 0;

Inherit subList  = FALSE, withIn = FALSE;

Inherit proFor_openFile( List *fileP )
	{
	char *nameP;
	FILE *newFileP;
	State *prevStateP = stateP->prevStateP;
	List *subP;
	
	if (fileP == NULL)
		return FALSE;
    if (fileP->u.p.type != LITERAL &&
        fileP->u.p.type != ALPHA)
		return FALSE;
	subP = fileP->data.dataP;
	if (subP->nextP != NULL)
		return FALSE;
	nameP = subP->data.dataP;
    if (fileP->u.p.type == LITERAL)
		{
		nameP[strlen(nameP)-1] = '\0';
		newFileP = fopen( &nameP[1], "a" );
		nameP[strlen(nameP)] = '\"';
		}
	else
		newFileP = fopen( nameP, "a" );

	if (newFileP == NULL)
		{
		proFor_print("\nERROR - File not found...");
		exit_state();
		return FALSE;
		}
	if (prevStateP != stateSpaceP && stateP->outP != prevStateP->outP)
		proFor_closeFile( stateP );
	subP->nextP = newFileP;
	stateP->outP = proMem_getAvail();
	*(stateP->outP) = *fileP;
	stateP->outP->nextP = NULL;
	return TRUE;
	}

void proFor_closeFile( State *stP )
	{
	if ((FILE *)(((List *)stP->outP->data.dataP)->nextP) != 
		stdout)
		{
		fclose( ((List *)stP->outP->data.dataP)->nextP );
		((List *)stP->outP->data.dataP)->nextP = NULL;
		stP->inP = proMem_getAvail();
		*(stP->outP) = *(List *)outDescrP->nextP;
		}
	}


void proFor_out( char *s )
	{
	if (s[0] == ')' && !subList)
		{
		if (withIn )
			proFor_newLine();
		proFor_tabulate();
		}
	withIn = TRUE;
	if (s[0] == '\"' || s[0] == '\'')
		if ( !(P_noEnters( s )  &&
			curX + proFor_size( s ) < maxWidth) )
		proFor_newLine();
	if (s[0] == '(')
		{
		if (subList )
			proFor_newLine();
		subList = TRUE;
		proFor_indent();
		proFor_tabulate();
		}
	if (curX + proFor_size( s ) >= maxWidth)
		proFor_newLine();
	proFor_print( s );
	if (s[0] == ')')
		{
		subList = FALSE;	
		proFor_undent();
		proFor_newLine();
		withIn = FALSE;
		}					
	}



/*
	Tabulation. 
*/
void proFor_indent( void )
	{
	if (indent++ == maxIndent) indent = 0;
	}
	
void proFor_undent( void )
	{
	indent--;
	if (indent == -1) indent = maxIndent;
	}	

void proFor_tabulate( void )
	{
	int i;
	
	for (i=curX;i<indent*tabSize;i++)
		proFor_print( "" );
	}	

void proFor_newLine( void )
	{
	fprintf( STREAM_OUT, "\n" );
	if (STREAM_OUT == stdout)
		fprintf( STREAM_OUT, "#%0.3d  ", stateP->process );
	curX = 0;
	}

void proFor_print( char *s )
	{
	int i;
	char *lnP = s;
	
	for (i=0;i<strlen( s );i++)
		{
		curX++;
		if (s[i] == '\n')
			{
			s[i] = '\0';
			fprintf( STREAM_OUT, "%s", lnP );
			proFor_newLine();
			s[i] = '\n';
			lnP = &s[i+1];
			}
		}	
	fprintf( STREAM_OUT, "%s ", lnP );
    curX++;
    }

int proFor_size( char *s )
	{
	int retInt = 0, i = 0;
	
	while (s[i] != '\n' && s[i++] != '\0')
		retInt++;
	return retInt;
	}	

Inherit P_noEnters( char *s )
	{
	int i = 0;
	Inherit answer = TRUE;
	
	while (s[i] != '\0' && answer)
		if (s[i++] == '\n')
			answer = FALSE;
	return answer;
	}



